/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell.p12;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.console.karaf.completer.ECCurveNameCompleter;
import org.xipki.security.pkcs12.P12KeyGenerationResult;
import org.xipki.security.pkcs12.P12KeyGenerator;
import org.xipki.security.shell.p12.P12KeyGenCommandSupport;

@Command(scope="xi", name="ec-p12", description="generate EC keypair in PKCS#12 keystore")
@Service
public class P12ECKeyGenCmd
extends P12KeyGenCommandSupport {
    @Option(name="--subject", aliases={"-s"}, description="subject of the self-signed certificate")
    protected String subject;
    @Option(name="--curve", description="EC curve name or OID")
    @Completion(value=ECCurveNameCompleter.class)
    private String curveName = "secp256r1";

    protected Object execute0() throws Exception {
        P12KeyGenerationResult keypair = new P12KeyGenerator().generateECKeypair(this.curveName, this.getKeyGenParameters(), this.subject);
        this.saveKey(keypair);
        return null;
    }
}

