/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell.p12;

import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.xipki.common.util.ParamUtil;
import org.xipki.console.karaf.completer.FilePathCompleter;
import org.xipki.security.pkcs12.KeystoreGenerationParameters;
import org.xipki.security.pkcs12.P12KeyGenerationResult;
import org.xipki.security.shell.KeyGenCommandSupport;

public abstract class P12KeyGenCommandSupport
extends KeyGenCommandSupport {
    @Option(name="--out", aliases={"-o"}, required=true, description="where to save the key\n(required)")
    @Completion(value=FilePathCompleter.class)
    protected String keyOutFile;
    @Option(name="--password", description="password of the keystore file")
    protected String password;

    protected void saveKey(P12KeyGenerationResult keyGenerationResult) throws IOException {
        ParamUtil.requireNonNull((String)"keyGenerationResult", (Object)keyGenerationResult);
        File p12File = new File(this.keyOutFile);
        this.saveVerbose("saved PKCS#12 keystore to file", p12File, keyGenerationResult.keystore());
    }

    protected KeystoreGenerationParameters getKeyGenParameters() throws IOException {
        KeystoreGenerationParameters params = new KeystoreGenerationParameters(this.getPassword());
        SecureRandom random = this.securityFactory.getRandom4Key();
        if (random != null) {
            params.setRandom(random);
        }
        return params;
    }

    private char[] getPassword() throws IOException {
        char[] pwdInChar = this.readPasswordIfNotSet(this.password);
        if (pwdInChar != null) {
            this.password = new String(pwdInChar);
        }
        return pwdInChar;
    }
}

