/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.shell.p12;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.console.karaf.IllegalCmdParamException;
import org.xipki.security.pkcs12.P12KeyGenerationResult;
import org.xipki.security.pkcs12.P12KeyGenerator;
import org.xipki.security.shell.p12.P12KeyGenCommandSupport;

@Command(scope="xi", name="rsa-p12", description="generate RSA keypair in PKCS#12 keystore")
@Service
public class P12RSAKeyGenCmd
extends P12KeyGenCommandSupport {
    @Option(name="--subject", aliases={"-s"}, description="subject of the self-signed certificate")
    private String subject;
    @Option(name="--key-size", description="keysize in bit")
    private Integer keysize = 2048;
    @Option(name="-e", description="public exponent")
    private String publicExponent = "0x10001";

    protected Object execute0() throws Exception {
        if (this.keysize % 1024 != 0) {
            throw new IllegalCmdParamException("keysize is not multiple of 1024: " + this.keysize);
        }
        P12KeyGenerationResult keypair = new P12KeyGenerator().generateRSAKeypair(this.keysize.intValue(), P12RSAKeyGenCmd.toBigInt((String)this.publicExponent), this.getKeyGenParameters(), this.subject);
        this.saveKey(keypair);
        return null;
    }
}

