/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.speed.p11;

import org.xipki.common.util.ParamUtil;
import org.xipki.security.SecurityFactory;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.speed.p11.P11SignLoadTest;

public class P11ECSignLoadTest
extends P11SignLoadTest {
    public P11ECSignLoadTest(SecurityFactory securityFactory, P11Slot slot, String signatureAlgorithm, String curveNameOrOid) throws Exception {
        super(securityFactory, slot, signatureAlgorithm, P11ECSignLoadTest.generateKey(slot, curveNameOrOid), "PKCS#11 EC signature creation\ncurve: " + curveNameOrOid);
    }

    private static P11ObjectIdentifier generateKey(P11Slot slot, String curveNameOrOid) throws Exception {
        ParamUtil.requireNonNull((String)"slot", (Object)slot);
        ParamUtil.requireNonNull((String)"curveNameOrOid", (Object)curveNameOrOid);
        return slot.generateECKeypair(curveNameOrOid, "loadtest-" + System.currentTimeMillis(), P11ECSignLoadTest.getNewKeyControl());
    }
}

