/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.speed.p11;

import java.security.SecureRandom;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.SecurityFactory;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.speed.p11.P11SignLoadTest;
import org.xipki.security.speed.p12.P12HMACSignLoadTest;

public class P11HMACSignLoadTest
extends P11SignLoadTest {
    public P11HMACSignLoadTest(SecurityFactory securityFactory, P11Slot slot, String signatureAlgorithm) throws Exception {
        super(securityFactory, slot, signatureAlgorithm, P11HMACSignLoadTest.generateKey(slot, signatureAlgorithm), "PKCS#11 HMAC signature creation");
    }

    private static P11ObjectIdentifier generateKey(P11Slot slot, String signatureAlgorithm) throws Exception {
        ParamUtil.requireNonNull((String)"slot", (Object)slot);
        int keysize = P12HMACSignLoadTest.getKeysize(signatureAlgorithm);
        byte[] keyBytes = new byte[keysize / 8];
        new SecureRandom().nextBytes(keyBytes);
        return slot.createSecretKey(16L, keyBytes, "loadtest-" + System.currentTimeMillis(), P11HMACSignLoadTest.getNewKeyControl());
    }
}

