/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.speed.p11;

import java.math.BigInteger;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.speed.p11.P11KeyGenLoadTest;

public class P11RSAKeyGenLoadTest
extends P11KeyGenLoadTest {
    private final int keysize;
    private final BigInteger publicExponent;

    public P11RSAKeyGenLoadTest(P11Slot slot, int keysize, BigInteger publicExponent) throws Exception {
        super(slot, "PKCS#11 RSA key generation\nkeysize: " + keysize + "\npublic exponent: " + publicExponent);
        this.keysize = keysize;
        this.publicExponent = publicExponent;
    }

    @Override
    protected void genKeypair() throws Exception {
        P11ObjectIdentifier objId = this.slot.generateRSAKeypair(this.keysize, this.publicExponent, this.getDummyLabel(), this.getControl());
        this.slot.removeIdentity(objId);
    }
}

