/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.speed.p11;

import java.math.BigInteger;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.SecurityFactory;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.speed.p11.P11SignLoadTest;

public class P11RSASignLoadTest
extends P11SignLoadTest {
    public P11RSASignLoadTest(SecurityFactory securityFactory, P11Slot slot, String signatureAlgorithm, int keysize, BigInteger publicExponent) throws Exception {
        super(securityFactory, slot, signatureAlgorithm, P11RSASignLoadTest.generateKey(slot, keysize, publicExponent), "PKCS#11 RSA signature creation\nkeysize: " + keysize + "\npublic exponent: " + publicExponent);
    }

    private static P11ObjectIdentifier generateKey(P11Slot slot, int keysize, BigInteger publicExponent) throws Exception {
        ParamUtil.requireNonNull((String)"slot", (Object)slot);
        return slot.generateRSAKeypair(keysize, publicExponent, "loadtest-" + System.currentTimeMillis(), P11RSASignLoadTest.getNewKeyControl());
    }
}

