/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.speed.p11;

import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.LoadExecutor;
import org.xipki.common.ObjectCreationException;
import org.xipki.common.util.LogUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.pkcs11.P11NewKeyControl;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;

public abstract class P11SignLoadTest
extends LoadExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(P11SignLoadTest.class);
    private final P11Slot slot;
    private final ConcurrentContentSigner signer;
    private final P11ObjectIdentifier objectId;

    public P11SignLoadTest(SecurityFactory securityFactory, P11Slot slot, String signatureAlgorithm, P11ObjectIdentifier objectId, String description) throws ObjectCreationException {
        super(description + "\nsignature algorithm: " + signatureAlgorithm);
        ParamUtil.requireNonNull((String)"securityFactory", (Object)securityFactory);
        ParamUtil.requireNonNull((String)"slot", (Object)slot);
        ParamUtil.requireNonBlank((String)"signatureAlgorithm", (String)signatureAlgorithm);
        ParamUtil.requireNonNull((String)"objectId", (Object)objectId);
        this.slot = slot;
        this.objectId = objectId;
        P11SlotIdentifier slotId = slot.slotId();
        SignerConf signerConf = SignerConf.getPkcs11SignerConf((String)slot.moduleName(), null, (Long)slotId.id(), null, (byte[])objectId.id(), (String)signatureAlgorithm, (int)20);
        try {
            this.signer = securityFactory.createSigner("PKCS11", signerConf, (X509Certificate)null);
        }
        catch (ObjectCreationException ex) {
            this.shutdown();
            throw ex;
        }
    }

    protected void shutdown() {
        try {
            this.slot.removeIdentity(this.objectId);
        }
        catch (Exception ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not delete PKCS#11 key " + this.objectId));
        }
    }

    protected static P11NewKeyControl getNewKeyControl() {
        P11NewKeyControl control = new P11NewKeyControl();
        control.setExtractable(true);
        return control;
    }

    protected Runnable getTestor() throws Exception {
        return new Testor();
    }

    class Testor
    implements Runnable {
        final byte[] data = new byte[1024];

        public Testor() {
            new SecureRandom().nextBytes(this.data);
        }

        @Override
        public void run() {
            while (!P11SignLoadTest.this.stop() && P11SignLoadTest.this.getErrorAccout() < 1L) {
                try {
                    P11SignLoadTest.this.signer.sign(this.data);
                    P11SignLoadTest.this.account(1, 0);
                }
                catch (Exception ex) {
                    P11SignLoadTest.this.account(1, 1);
                }
            }
        }
    }
}

