/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.speed.p11.cmd;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.common.LoadExecutor;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.speed.cmd.DSAControl;
import org.xipki.security.speed.p11.P11DSAKeyGenLoadTest;
import org.xipki.security.speed.p11.cmd.BSpeedP11CommandSupport;

@Command(scope="xi", name="bspeed-dsa-gen-p11", description="performance test of PKCS#11 DSA key generation (batch)")
@Service
public class BSpeedP11DSAKeyGenCmd
extends BSpeedP11CommandSupport {
    private final Queue<DSAControl> queue = new LinkedList<DSAControl>();

    public BSpeedP11DSAKeyGenCmd() {
        this.queue.add(new DSAControl(1024, 160));
        this.queue.add(new DSAControl(2048, 224));
        this.queue.add(new DSAControl(2048, 256));
        this.queue.add(new DSAControl(3072, 256));
    }

    @Override
    protected LoadExecutor nextTester() throws Exception {
        DSAControl control = this.queue.poll();
        if (control == null) {
            return null;
        }
        P11Slot slot = this.getSlot();
        return new P11DSAKeyGenLoadTest(slot, control.plen(), control.qlen());
    }
}

