/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.speed.p11.cmd;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.common.LoadExecutor;
import org.xipki.console.karaf.IllegalCmdParamException;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.speed.cmd.DSAControl;
import org.xipki.security.speed.cmd.completer.DSASigAlgCompleter;
import org.xipki.security.speed.p11.P11DSASignLoadTest;
import org.xipki.security.speed.p11.cmd.BSpeedP11CommandSupport;

@Command(scope="xi", name="bspeed-dsa-sign-p11", description="performance test of PKCS#11 DSA signature creation (batch)")
@Service
public class BSpeedP11DSASignCmd
extends BSpeedP11CommandSupport {
    @Option(name="--sig-algo", required=true, description="signature algorithm\n(required)")
    @Completion(value=DSASigAlgCompleter.class)
    private String sigAlgo;
    private final Queue<DSAControl> queue = new LinkedList<DSAControl>();

    public BSpeedP11DSASignCmd() {
        this.queue.add(new DSAControl(1024, 160));
        this.queue.add(new DSAControl(2048, 224));
        this.queue.add(new DSAControl(2048, 256));
        this.queue.add(new DSAControl(3072, 256));
    }

    @Override
    protected LoadExecutor nextTester() throws Exception {
        DSAControl control = this.queue.poll();
        if (control == null) {
            return null;
        }
        P11Slot slot = this.getSlot();
        if (control.plen() == 1024 && !"SHA1withDSA".equalsIgnoreCase(this.sigAlgo)) {
            throw new IllegalCmdParamException("only SHA1withDSA is permitted for DSA with 1024 bit");
        }
        return new P11DSASignLoadTest(this.securityFactory, slot, this.sigAlgo, control.plen(), control.qlen());
    }
}

