/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.speed.p11.cmd;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.common.LoadExecutor;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.speed.cmd.ECControl;
import org.xipki.security.speed.p11.P11ECKeyGenLoadTest;
import org.xipki.security.speed.p11.cmd.BSpeedP11CommandSupport;

@Command(scope="xi", name="bspeed-ec-gen-p11", description="performance test of PKCS#11 EC key generation (batch)")
@Service
public class BSpeedP11ECKeyGenCmd
extends BSpeedP11CommandSupport {
    private final Queue<ECControl> queue = new LinkedList<ECControl>();

    public BSpeedP11ECKeyGenCmd() {
        for (String curveName : this.getECCurveNames()) {
            this.queue.add(new ECControl(curveName));
        }
    }

    @Override
    protected LoadExecutor nextTester() throws Exception {
        ECControl control = this.queue.poll();
        if (control == null) {
            return null;
        }
        P11Slot slot = this.getSlot();
        return new P11ECKeyGenLoadTest(slot, control.curveName());
    }
}

