/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.speed.p11.cmd;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.common.LoadExecutor;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.speed.cmd.ECControl;
import org.xipki.security.speed.cmd.completer.ECDSASigAlgCompleter;
import org.xipki.security.speed.p11.P11ECSignLoadTest;
import org.xipki.security.speed.p11.cmd.BSpeedP11CommandSupport;

@Command(scope="xi", name="bspeed-ec-sign-p11", description="performance test of PKCS#11 EC signature creation (batch)")
@Service
public class BSpeedP11ECSignCmd
extends BSpeedP11CommandSupport {
    @Option(name="--sig-algo", required=true, description="signature algorithm\n(required)")
    @Completion(value=ECDSASigAlgCompleter.class)
    private String sigAlgo;
    private final Queue<ECControl> queue = new LinkedList<ECControl>();

    public BSpeedP11ECSignCmd() {
        for (String curveName : this.getECCurveNames()) {
            this.queue.add(new ECControl(curveName));
        }
    }

    @Override
    protected LoadExecutor nextTester() throws Exception {
        ECControl control = this.queue.poll();
        if (control == null) {
            return null;
        }
        P11Slot slot = this.getSlot();
        return new P11ECSignLoadTest(this.securityFactory, slot, this.sigAlgo, control.curveName());
    }
}

