/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.speed.p11.cmd;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.common.LoadExecutor;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.speed.cmd.RSAControl;
import org.xipki.security.speed.p11.P11RSAKeyGenLoadTest;
import org.xipki.security.speed.p11.cmd.BSpeedP11CommandSupport;

@Command(scope="xi", name="bspeed-rsa-gen-p11", description="performance test of PKCS#11 RSA key generation (batch)")
@Service
public class BSpeedP11RSAKeyGenCmd
extends BSpeedP11CommandSupport {
    private final Queue<RSAControl> queue = new LinkedList<RSAControl>();

    public BSpeedP11RSAKeyGenCmd() {
        this.queue.add(new RSAControl(1024));
        this.queue.add(new RSAControl(2048));
        this.queue.add(new RSAControl(3072));
        this.queue.add(new RSAControl(4096));
    }

    @Override
    protected LoadExecutor nextTester() throws Exception {
        RSAControl control = this.queue.poll();
        if (control == null) {
            return null;
        }
        P11Slot slot = this.getSlot();
        return new P11RSAKeyGenLoadTest(slot, control.modulusLen(), BSpeedP11RSAKeyGenCmd.toBigInt((String)"0x10001"));
    }
}

