/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.speed.p11.cmd;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.common.LoadExecutor;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.speed.cmd.RSAControl;
import org.xipki.security.speed.cmd.completer.RSASigAlgCompleter;
import org.xipki.security.speed.p11.P11RSASignLoadTest;
import org.xipki.security.speed.p11.cmd.BSpeedP11CommandSupport;

@Command(scope="xi", name="bspeed-rsa-sign-p11", description="performance test of PKCS#11 RSA signature creation (batch)")
@Service
public class BSpeedP11RSASignCmd
extends BSpeedP11CommandSupport {
    @Option(name="--sig-algo", required=true, description="signature algorithm\n(required)")
    @Completion(value=RSASigAlgCompleter.class)
    private String sigAlgo;
    private final Queue<RSAControl> queue = new LinkedList<RSAControl>();

    public BSpeedP11RSASignCmd() {
        this.queue.add(new RSAControl(1024));
        this.queue.add(new RSAControl(2048));
        this.queue.add(new RSAControl(3072));
        this.queue.add(new RSAControl(4096));
    }

    @Override
    protected LoadExecutor nextTester() throws Exception {
        RSAControl control = this.queue.poll();
        if (control == null) {
            return null;
        }
        P11Slot slot = this.getSlot();
        return new P11RSASignLoadTest(this.securityFactory, slot, this.sigAlgo, control.modulusLen(), BSpeedP11RSASignCmd.toBigInt((String)"0x10001"));
    }
}

