/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.speed.p11.cmd;

import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.xipki.console.karaf.IllegalCmdParamException;
import org.xipki.security.exception.P11TokenException;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11CryptServiceFactory;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.speed.cmd.SingleSpeedCommandSupport;
import org.xipki.security.speed.p11.cmd.P11ModuleNameCompleter;

public abstract class SpeedP11CommandSupport
extends SingleSpeedCommandSupport {
    @Reference(optional=true)
    protected P11CryptServiceFactory p11CryptServiceFactory;
    @Option(name="--slot", required=true, description="slot index\n(required)")
    protected Integer slotIndex;
    @Option(name="--module", description="Name of the PKCS#11 module.")
    @Completion(value=P11ModuleNameCompleter.class)
    protected String moduleName = "default";

    protected P11Slot getSlot() throws XiSecurityException, P11TokenException, IllegalCmdParamException {
        P11CryptService p11Service = this.p11CryptServiceFactory.getP11CryptService(this.moduleName);
        if (p11Service == null) {
            throw new IllegalCmdParamException("undefined module " + this.moduleName);
        }
        P11Module module = p11Service.module();
        P11SlotIdentifier slotId = module.getSlotIdForIndex(this.slotIndex.intValue());
        return module.getSlot(slotId);
    }
}

