/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.speed.p11.cmd;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.common.LoadExecutor;
import org.xipki.console.karaf.IllegalCmdParamException;
import org.xipki.security.speed.cmd.completer.DSASigAlgCompleter;
import org.xipki.security.speed.p11.P11DSASignLoadTest;
import org.xipki.security.speed.p11.cmd.SpeedP11CommandSupport;

@Command(scope="xi", name="speed-dsa-sign-p11", description="performance test of PKCS#11 DSA signature creation")
@Service
public class SpeedP11DSASignCmd
extends SpeedP11CommandSupport {
    @Option(name="--plen", description="bit length of the prime")
    private Integer plen = 2048;
    @Option(name="--qlen", description="bit length of the sub-prime")
    private Integer qlen;
    @Option(name="--sig-algo", required=true, description="signature algorithm\n(required)")
    @Completion(value=DSASigAlgCompleter.class)
    private String sigAlgo;

    @Override
    protected LoadExecutor getTester() throws Exception {
        if (this.qlen == null) {
            this.qlen = this.plen >= 2048 ? 256 : 160;
        }
        if (this.plen == 1024 && !"SHA1withDSA".equalsIgnoreCase(this.sigAlgo)) {
            throw new IllegalCmdParamException("only SHA1withDSA is permitted for DSA with 1024 bit");
        }
        return new P11DSASignLoadTest(this.securityFactory, this.getSlot(), this.sigAlgo, this.plen, this.qlen);
    }
}

