/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.speed.p12;

import org.xipki.security.SecurityFactory;
import org.xipki.security.pkcs12.KeystoreGenerationParameters;
import org.xipki.security.pkcs12.P12KeyGenerationResult;
import org.xipki.security.pkcs12.P12KeyGenerator;
import org.xipki.security.speed.p12.P12SignLoadTest;

public class P12AESGmacSignLoadTest
extends P12SignLoadTest {
    public P12AESGmacSignLoadTest(SecurityFactory securityFactory, String signatureAlgorithm) throws Exception {
        super("JCEKS", securityFactory, signatureAlgorithm, P12AESGmacSignLoadTest.generateKeystore(signatureAlgorithm), "JCEKS AES-GMAC signature creation");
    }

    private static byte[] generateKeystore(String signatureAlgorithm) throws Exception {
        int keysize = P12AESGmacSignLoadTest.getKeysize(signatureAlgorithm);
        P12KeyGenerationResult identity = new P12KeyGenerator().generateSecretKey("AES", keysize, new KeystoreGenerationParameters("1234".toCharArray()));
        return identity.keystore();
    }

    public static int getKeysize(String hmacAlgorithm) {
        int keysize;
        if ("AES128-GMAC".equalsIgnoreCase(hmacAlgorithm)) {
            keysize = 128;
        } else if ("AES192-GMAC".equalsIgnoreCase(hmacAlgorithm)) {
            keysize = 192;
        } else if ("AES256-GMAC".equalsIgnoreCase(hmacAlgorithm)) {
            keysize = 256;
        } else {
            throw new IllegalArgumentException("unknown HMAC algorithm " + hmacAlgorithm);
        }
        return keysize;
    }
}

