/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.speed.p12;

import java.security.SecureRandom;
import org.xipki.security.SecurityFactory;
import org.xipki.security.pkcs12.KeystoreGenerationParameters;
import org.xipki.security.pkcs12.P12KeyGenerationResult;
import org.xipki.security.pkcs12.P12KeyGenerator;
import org.xipki.security.speed.p12.P12SignLoadTest;

public class P12DSASignLoadTest
extends P12SignLoadTest {
    public P12DSASignLoadTest(SecurityFactory securityFactory, String signatureAlgorithm, int plength, int qlength) throws Exception {
        super(securityFactory, signatureAlgorithm, P12DSASignLoadTest.generateKeystore(plength, qlength), "PKCS#12 DSA signature creation\nplength: " + plength + "\nqlength: " + qlength);
    }

    private static byte[] generateKeystore(int plength, int qlength) throws Exception {
        byte[] keystoreBytes = P12DSASignLoadTest.getPrecomputedDSAKeystore(plength, qlength);
        if (keystoreBytes == null) {
            KeystoreGenerationParameters params = new KeystoreGenerationParameters("1234".toCharArray());
            params.setRandom(new SecureRandom());
            P12KeyGenerationResult identity = new P12KeyGenerator().generateDSAKeypair(plength, qlength, params, null);
            keystoreBytes = identity.keystore();
        }
        return keystoreBytes;
    }
}

