/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.speed.p12;

import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.xipki.security.SecurityFactory;
import org.xipki.security.speed.p12.P12KeyGenLoadTest;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.KeyUtil;

public class P12ECKeyGenLoadTest
extends P12KeyGenLoadTest {
    private final ASN1ObjectIdentifier curveOid;

    public P12ECKeyGenLoadTest(String curveNameOrOid, SecurityFactory securityFactory) throws Exception {
        super("PKCS#12 EC key generation\ncurve: " + curveNameOrOid, securityFactory);
        ASN1ObjectIdentifier oid = AlgorithmUtil.getCurveOidForCurveNameOrOid((String)curveNameOrOid);
        if (oid == null) {
            throw new IllegalArgumentException("invalid curve name or OID " + curveNameOrOid);
        }
        this.curveOid = oid;
    }

    @Override
    protected void generateKeypair(SecureRandom random) throws Exception {
        KeyUtil.generateECKeypair((ASN1ObjectIdentifier)this.curveOid, (SecureRandom)random);
    }
}

