/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.speed.p12;

import java.security.SecureRandom;
import org.xipki.security.SecurityFactory;
import org.xipki.security.pkcs12.KeystoreGenerationParameters;
import org.xipki.security.pkcs12.P12KeyGenerationResult;
import org.xipki.security.pkcs12.P12KeyGenerator;
import org.xipki.security.speed.p12.P12SignLoadTest;

public class P12ECSignLoadTest
extends P12SignLoadTest {
    public P12ECSignLoadTest(SecurityFactory securityFactory, String signatureAlgorithm, String curveNameOrOid) throws Exception {
        super(securityFactory, signatureAlgorithm, P12ECSignLoadTest.generateKeystore(curveNameOrOid), "PKCS#12 EC signature creation\ncurve: " + curveNameOrOid);
    }

    private static byte[] generateKeystore(String curveNameOrOid) throws Exception {
        byte[] keystoreBytes = P12ECSignLoadTest.getPrecomputedECKeystore(curveNameOrOid);
        if (keystoreBytes == null) {
            KeystoreGenerationParameters params = new KeystoreGenerationParameters("1234".toCharArray());
            params.setRandom(new SecureRandom());
            P12KeyGenerationResult identity = new P12KeyGenerator().generateECKeypair(curveNameOrOid, params, null);
            keystoreBytes = identity.keystore();
        }
        return keystoreBytes;
    }
}

