/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.speed.p12;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.xipki.security.SecurityFactory;
import org.xipki.security.pkcs12.KeystoreGenerationParameters;
import org.xipki.security.pkcs12.P12KeyGenerationResult;
import org.xipki.security.pkcs12.P12KeyGenerator;
import org.xipki.security.speed.p12.P12SignLoadTest;

public class P12RSASignLoadTest
extends P12SignLoadTest {
    public P12RSASignLoadTest(SecurityFactory securityFactory, String signatureAlgorithm, int keysize, BigInteger publicExponent) throws Exception {
        super(securityFactory, signatureAlgorithm, P12RSASignLoadTest.generateKeystore(keysize, publicExponent), "PKCS#12 RSA signature creation\nkeysize: " + keysize + "\npublic exponent: " + publicExponent);
    }

    private static byte[] generateKeystore(int keysize, BigInteger publicExponent) throws Exception {
        byte[] keystoreBytes = P12RSASignLoadTest.getPrecomputedRSAKeystore(keysize, publicExponent);
        if (keystoreBytes == null) {
            KeystoreGenerationParameters params = new KeystoreGenerationParameters("1234".toCharArray());
            params.setRandom(new SecureRandom());
            P12KeyGenerationResult identity = new P12KeyGenerator().generateRSAKeypair(keysize, publicExponent, params, null);
            keystoreBytes = identity.keystore();
        }
        return keystoreBytes;
    }
}

