/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.speed.p12;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.xipki.common.LoadExecutor;
import org.xipki.common.util.IoUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.speed.p12.P12ECSignLoadTest;
import org.xipki.security.util.AlgorithmUtil;

public abstract class P12SignLoadTest
extends LoadExecutor {
    protected static final String PASSWORD = "1234";
    private final ConcurrentContentSigner signer;

    public P12SignLoadTest(SecurityFactory securityFactory, String signatureAlgorithm, byte[] keystore, String description) throws Exception {
        this("PKCS12", securityFactory, signatureAlgorithm, keystore, description);
    }

    public P12SignLoadTest(String tokenType, SecurityFactory securityFactory, String signatureAlgorithm, byte[] keystore, String description) throws Exception {
        super(description);
        ParamUtil.requireNonNull((String)"securityFactory", (Object)securityFactory);
        ParamUtil.requireNonBlank((String)"signatureAlgorithm", (String)signatureAlgorithm);
        ParamUtil.requireNonNull((String)"keystore", (Object)keystore);
        SignerConf signerConf = SignerConf.getKeystoreSignerConf((InputStream)new ByteArrayInputStream(keystore), (String)PASSWORD, (String)signatureAlgorithm, (int)20);
        this.signer = securityFactory.createSigner(tokenType, signerConf, (X509Certificate)null);
    }

    protected Runnable getTestor() throws Exception {
        return new Testor();
    }

    protected static byte[] getPrecomputedRSAKeystore(int keysize, BigInteger publicExponent) throws IOException {
        return P12SignLoadTest.getPrecomputedKeystore("rsa-" + keysize + "-0x" + publicExponent.toString(16) + ".p12");
    }

    protected static byte[] getPrecomputedDSAKeystore(int plength, int qlength) throws IOException {
        return P12SignLoadTest.getPrecomputedKeystore("dsa-" + plength + "-" + qlength + ".p12");
    }

    protected static byte[] getPrecomputedECKeystore(String curveNamOrOid) throws IOException {
        ASN1ObjectIdentifier oid = AlgorithmUtil.getCurveOidForCurveNameOrOid((String)curveNamOrOid);
        if (oid == null) {
            return null;
        }
        return P12SignLoadTest.getPrecomputedKeystore("ec-" + oid.getId() + ".p12");
    }

    private static byte[] getPrecomputedKeystore(String filename) throws IOException {
        InputStream in = P12ECSignLoadTest.class.getResourceAsStream("/testkeys/" + filename);
        return in == null ? null : IoUtil.read((InputStream)in);
    }

    class Testor
    implements Runnable {
        private final byte[] data = new byte[1024];

        public Testor() {
            new SecureRandom().nextBytes(this.data);
        }

        @Override
        public void run() {
            while (!P12SignLoadTest.this.stop() && P12SignLoadTest.this.getErrorAccout() < 1L) {
                try {
                    P12SignLoadTest.this.signer.sign(this.data);
                    P12SignLoadTest.this.account(1, 0);
                }
                catch (Exception ex) {
                    P12SignLoadTest.this.account(1, 1);
                }
            }
        }
    }
}

