/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.speed.p12.cmd;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.common.LoadExecutor;
import org.xipki.security.speed.cmd.BatchSpeedCommandSupport;
import org.xipki.security.speed.cmd.DSAControl;
import org.xipki.security.speed.p12.P12DSAKeyGenLoadTest;

@Command(scope="xi", name="bspeed-dsa-gen-p12", description="performance test of PKCS#12 DSA key generation (batch)")
@Service
public class BSpeedP12DSAKeyGenCmd
extends BatchSpeedCommandSupport {
    private final Queue<DSAControl> queue = new LinkedList<DSAControl>();

    public BSpeedP12DSAKeyGenCmd() {
        this.queue.add(new DSAControl(1024, 160));
        this.queue.add(new DSAControl(2048, 224));
        this.queue.add(new DSAControl(2048, 256));
        this.queue.add(new DSAControl(3072, 256));
    }

    @Override
    protected LoadExecutor nextTester() throws Exception {
        DSAControl control = this.queue.poll();
        if (control == null) {
            return null;
        }
        return new P12DSAKeyGenLoadTest(control.plen(), control.qlen(), this.securityFactory);
    }
}

