/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.speed.p12.cmd;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.common.LoadExecutor;
import org.xipki.security.speed.cmd.DSAControl;
import org.xipki.security.speed.p12.P12DSASignLoadTest;
import org.xipki.security.speed.p12.cmd.BSpeedP12SignCommandSupport;

@Command(scope="xi", name="bspeed-dsa-sign-p12", description="performance test of PKCS#12 DSA signature creation")
@Service
public class BSpeedP12DSASignCmd
extends BSpeedP12SignCommandSupport {
    private final Queue<DSAControl> queue = new LinkedList<DSAControl>();

    public BSpeedP12DSASignCmd() {
        this.queue.add(new DSAControl(1024, 160));
        this.queue.add(new DSAControl(2048, 224));
        this.queue.add(new DSAControl(2048, 256));
        this.queue.add(new DSAControl(3072, 256));
    }

    @Override
    protected LoadExecutor nextTester() throws Exception {
        DSAControl control = this.queue.poll();
        if (control == null) {
            return null;
        }
        if (control.plen() == 1024) {
            this.sigAlgo = "SHA1withDSA";
        }
        return new P12DSASignLoadTest(this.securityFactory, this.sigAlgo, control.plen(), control.qlen());
    }
}

