/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.speed.p12.cmd;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.common.LoadExecutor;
import org.xipki.security.speed.cmd.ECControl;
import org.xipki.security.speed.p12.P12ECSignLoadTest;
import org.xipki.security.speed.p12.cmd.BSpeedP12SignCommandSupport;

@Command(scope="xi", name="bspeed-ec-sign-p12", description="performance test of PKCS#12 EC signature creation (batch)")
@Service
public class BSpeedP12ECSignCmd
extends BSpeedP12SignCommandSupport {
    private final Queue<ECControl> queue = new LinkedList<ECControl>();

    public BSpeedP12ECSignCmd() {
        for (String curveName : this.getECCurveNames()) {
            this.queue.add(new ECControl(curveName));
        }
    }

    @Override
    protected LoadExecutor nextTester() throws Exception {
        ECControl control = this.queue.poll();
        if (control == null) {
            return null;
        }
        return new P12ECSignLoadTest(this.securityFactory, this.sigAlgo, control.curveName());
    }
}

