/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.speed.p12.cmd;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.common.LoadExecutor;
import org.xipki.security.speed.cmd.BatchSpeedCommandSupport;
import org.xipki.security.speed.cmd.RSAControl;
import org.xipki.security.speed.p12.P12RSAKeyGenLoadTest;

@Command(scope="xi", name="bspeed-rsa-gen-p12", description="performance test of PKCS#12 RSA key generation (batch)")
@Service
public class BSpeedP12RSAKeyGenCmd
extends BatchSpeedCommandSupport {
    private final Queue<RSAControl> queue = new LinkedList<RSAControl>();

    public BSpeedP12RSAKeyGenCmd() {
        this.queue.add(new RSAControl(1024));
        this.queue.add(new RSAControl(2048));
        this.queue.add(new RSAControl(3072));
        this.queue.add(new RSAControl(4096));
    }

    @Override
    protected LoadExecutor nextTester() throws Exception {
        RSAControl control = this.queue.poll();
        if (control == null) {
            return null;
        }
        return new P12RSAKeyGenLoadTest(control.modulusLen(), BSpeedP12RSAKeyGenCmd.toBigInt((String)"0x10001"), this.securityFactory);
    }
}

