/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.speed.p12.cmd;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.common.LoadExecutor;
import org.xipki.security.speed.cmd.completer.DSASigAlgCompleter;
import org.xipki.security.speed.p12.P12DSASignLoadTest;
import org.xipki.security.speed.p12.cmd.SpeedP12SignCommandSupport;

@Command(scope="xi", name="speed-dsa-sign-p12", description="performance test of PKCS#12 DSA signature creation")
@Service
public class SpeedP12DSASignCmd
extends SpeedP12SignCommandSupport {
    @Option(name="--plen", description="bit length of the prime")
    private Integer plen = 2048;
    @Option(name="--qlen", description="bit length of the sub-prime")
    private Integer qlen;
    @Option(name="--sig-algo", required=true, description="signature algorithm\n(required)")
    @Completion(value=DSASigAlgCompleter.class)
    private String sigAlgo;

    @Override
    protected LoadExecutor getTester() throws Exception {
        if (this.qlen == null) {
            this.qlen = this.plen >= 2048 ? 256 : 160;
        }
        return new P12DSASignLoadTest(this.securityFactory, this.sigAlgo, this.plen, this.qlen);
    }
}

