/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.console.karaf.command;

import java.io.File;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.console.karaf.XipkiCommandSupport;
import org.xipki.console.karaf.completer.FilePathCompleter;
import org.xipki.console.karaf.intern.FileUtils;

@Command(scope="xipki-cmd", name="rm", description="remove file or directory")
@Service
public class FileRmCmd
extends XipkiCommandSupport {
    @Argument(index=0, name="file", required=true, description="file or directory to be deleted\n(required)")
    @Completion(value=FilePathCompleter.class)
    private String targetPath;
    @Option(name="--recursive", aliases={"-r"}, description="remove directories and their contents recursively")
    private Boolean recursive = Boolean.FALSE;
    @Option(name="--force", aliases={"-f"}, description="ignore nonexistent files, never prompt")
    private Boolean force = Boolean.FALSE;

    @Override
    protected Object execute0() throws Exception {
        File target = new File(FileRmCmd.expandFilepath(this.targetPath));
        if (!target.exists()) {
            return null;
        }
        if (target.isDirectory()) {
            if (!this.recursive.booleanValue()) {
                this.println("Please use option --recursive to delete directory");
                return null;
            }
            if (this.force.booleanValue() || this.confirm("Do you want to remove directory " + this.targetPath, 3)) {
                FileUtils.deleteDirectory(target);
                this.println("removed directory " + this.targetPath);
            }
        } else if (this.force.booleanValue() || this.confirm("Do you want o remove file " + this.targetPath, 3)) {
            target.delete();
            this.println("removed file " + this.targetPath);
        }
        return null;
    }
}

