/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.console.karaf.command;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.common.util.IoUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.console.karaf.XipkiCommandSupport;
import org.xipki.console.karaf.completer.FilePathCompleter;

@Command(scope="xipki-cmd", name="replace", description="replace text in file")
@Service
public class ReplaceFileCmd
extends XipkiCommandSupport {
    @Argument(index=0, name="file", required=true, description="file\n(required)")
    @Completion(value=FilePathCompleter.class)
    private String source;
    @Option(name="--old", required=true, description="text to be replaced")
    private String oldText;
    @Option(name="--new", required=true, description="next text")
    private String newText;

    @Override
    protected Object execute0() throws Exception {
        File sourceFile = new File(ReplaceFileCmd.expandFilepath(this.source));
        if (!sourceFile.exists()) {
            System.err.println(this.source + " does not exist");
            return null;
        }
        if (!sourceFile.isFile()) {
            System.err.println(this.source + " is not a file");
            return null;
        }
        ParamUtil.requireNonBlank((String)"old", (String)this.oldText);
        this.replaceFile(sourceFile, this.oldText, this.newText);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceFile(File file, String oldText, String newText) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        ByteArrayOutputStream writer = new ByteArrayOutputStream();
        boolean changed = false;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.contains(oldText)) {
                    changed = true;
                    writer.write(line.replace(oldText, newText).getBytes());
                } else {
                    writer.write(line.getBytes());
                }
                writer.write(10);
            }
        }
        finally {
            writer.close();
            reader.close();
        }
        if (changed) {
            File newFile = new File(file.getPath() + "-new");
            byte[] newBytes = writer.toByteArray();
            IoUtil.save((File)file, (byte[])newBytes);
            newFile.renameTo(file);
        }
    }
}

