/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.console.karaf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.List;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.console.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.util.CollectionUtil;
import org.xipki.common.util.IoUtil;
import org.xipki.common.util.StringUtil;
import org.xipki.password.SecurePasswordInputPanel;

public abstract class XipkiCommandSupport
implements Action {
    private static final Logger LOG = LoggerFactory.getLogger(XipkiCommandSupport.class);
    @Reference
    protected Session session;

    protected abstract Object execute0() throws Exception;

    public Object execute() throws Exception {
        try {
            return this.execute0();
        }
        catch (Exception ex) {
            LOG.debug("Exception caught while executing command", (Throwable)ex);
            throw new Exception(ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    protected boolean isTrue(Boolean bo) {
        return bo != null && bo != false;
    }

    protected void saveVerbose(String promptPrefix, File file, byte[] encoded) throws IOException {
        File saveTo;
        block12: {
            saveTo = XipkiCommandSupport.expandFilepath(file);
            boolean randomSaveTo = false;
            if (saveTo.exists()) {
                try {
                    boolean bo = true;
                    while (saveTo.exists()) {
                        String answer = bo ? this.readPrompt("A file named '" + saveTo.getPath() + "' already exists. Do you want to replace it [yes/no]? ") : this.session.readLine(null, null);
                        if (answer == null) {
                            throw new IOException("interrupted");
                        }
                        if (!"yes".equalsIgnoreCase(answer)) {
                            if ("no".equalsIgnoreCase(answer)) {
                                String newFn;
                                while ((newFn = this.readPrompt("Enter name of file to save to ... ")).trim().isEmpty()) {
                                }
                                saveTo = new File(newFn);
                                continue;
                            }
                            this.readPrompt("Please answer with yes or no. ");
                            bo = false;
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException ex) {
                    saveTo = new File("tmp-" + XipkiCommandSupport.randomHex(6));
                    randomSaveTo = true;
                }
            }
            try {
                this.save(saveTo, encoded);
            }
            catch (IOException ex) {
                System.out.println("ERROR: " + ex.getMessage());
                if (randomSaveTo) break block12;
                saveTo = new File("tmp-" + XipkiCommandSupport.randomHex(6));
                this.save(saveTo, encoded);
            }
        }
        String tmpPromptPrefix = promptPrefix;
        if (tmpPromptPrefix == null || tmpPromptPrefix.isEmpty()) {
            tmpPromptPrefix = "saved to file";
        }
        this.println(tmpPromptPrefix + " " + saveTo.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(File file, byte[] encoded) throws IOException {
        File tmpFile = XipkiCommandSupport.expandFilepath(file);
        File parent = tmpFile.getParentFile();
        if (parent != null) {
            if (parent.exists()) {
                if (!parent.isDirectory()) {
                    throw new IOException("The path " + parent.getPath() + " is not a directory.");
                }
            } else {
                parent.mkdirs();
            }
        }
        try (FileOutputStream out = new FileOutputStream(tmpFile);){
            out.write(encoded);
        }
    }

    private static String randomHex(int numOfBytes) {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[numOfBytes];
        random.nextBytes(bytes);
        return new BigInteger(1, bytes).toString(16);
    }

    protected static boolean isEnabled(String enabledS, boolean defaultEnabled, String optionName) {
        return enabledS == null ? defaultEnabled : XipkiCommandSupport.isEnabled(enabledS, optionName);
    }

    private static boolean isEnabled(String enabledS, String optionName) {
        if ("yes".equalsIgnoreCase(enabledS) || "enabled".equalsIgnoreCase(enabledS) || "true".equalsIgnoreCase(enabledS)) {
            return true;
        }
        if ("no".equalsIgnoreCase(enabledS) || "disabled".equalsIgnoreCase(enabledS) || "false".equalsIgnoreCase(enabledS)) {
            return false;
        }
        throw new IllegalArgumentException("invalid option " + optionName + ": " + enabledS);
    }

    protected String readPrompt(String prompt) throws IOException {
        String tmpPrompt = prompt;
        if (StringUtil.isNotBlank((String)prompt) && !prompt.endsWith(" ")) {
            tmpPrompt = tmpPrompt + " ";
        }
        return this.readLine(tmpPrompt, null);
    }

    protected char[] readPasswordIfNotSet(String password) throws IOException {
        return this.readPasswordIfNotSet(null, password);
    }

    protected char[] readPasswordIfNotSet(String prompt, String password) throws IOException {
        if (password != null) {
            return password.toCharArray();
        }
        return this.readPassword(prompt);
    }

    protected char[] readPassword() throws IOException {
        return this.readPassword(null);
    }

    protected char[] readPassword(String prompt) throws IOException {
        String passwordUi;
        String tmpPrompt;
        String string = tmpPrompt = prompt == null ? "Password:" : prompt.trim();
        if (!tmpPrompt.endsWith(":")) {
            tmpPrompt = tmpPrompt + ":";
        }
        return "gui".equalsIgnoreCase(passwordUi = System.getProperty("org.xipki.console.passwordui")) ? SecurePasswordInputPanel.readPassword((String)tmpPrompt) : this.readLine(tmpPrompt, Character.valueOf('*')).toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readLine(String prompt, Character ch) throws IOException {
        Object oldIgnoreInterrupts = this.session.get("karaf.ignoreInterrupts");
        this.session.put("karaf.ignoreInterrupts", (Object)Boolean.TRUE);
        try {
            String line = this.session.readLine(prompt, ch);
            if (line == null) {
                throw new IOException("interrupted");
            }
            String string = line;
            return string;
        }
        finally {
            this.session.put("karaf.ignoreInterrupts", oldIgnoreInterrupts);
        }
    }

    protected static String expandFilepath(String path) {
        return IoUtil.expandFilepath((String)path);
    }

    protected static File expandFilepath(File file) {
        return IoUtil.expandFilepath((File)file);
    }

    protected void println(String message) {
        System.out.println(message);
    }

    protected void print(String message) {
        System.out.print(message);
    }

    protected static boolean isBlank(String str) {
        return StringUtil.isBlank((String)str);
    }

    protected static boolean isNotBlank(String str) {
        return StringUtil.isNotBlank((String)str);
    }

    protected static boolean isEmpty(Collection<?> col) {
        return CollectionUtil.isEmpty(col);
    }

    protected static boolean isNotEmpty(Collection<?> col) {
        return CollectionUtil.isNonEmpty(col);
    }

    protected static List<String> split(String str, String delim) {
        return StringUtil.split((String)str, (String)delim);
    }

    protected static BigInteger toBigInt(String str) {
        return XipkiCommandSupport.toBigInt(str, false);
    }

    protected static BigInteger toBigInt(String str, boolean defaultHex) {
        String tmpStr = str.trim();
        if (tmpStr.startsWith("0x") || tmpStr.startsWith("0X")) {
            if (tmpStr.length() > 2) {
                return new BigInteger(tmpStr.substring(2), 16);
            }
            throw new NumberFormatException("invalid integer '" + tmpStr + "'");
        }
        return new BigInteger(tmpStr, defaultHex ? 16 : 10);
    }

    protected boolean confirm(String prompt, int maxTries) throws IOException {
        String tmpPrompt;
        if (prompt == null || prompt.isEmpty()) {
            tmpPrompt = "[yes/no]? ";
        } else {
            tmpPrompt = '?' == prompt.charAt(prompt.length() - 1) ? prompt.substring(0, prompt.length() - 1) : prompt;
            tmpPrompt = tmpPrompt + " [yes/no]? ";
        }
        String answer = this.readLine(tmpPrompt, null);
        if (answer == null) {
            throw new IOException("interrupted");
        }
        for (int tries = 1; tries < maxTries; ++tries) {
            if ("yes".equalsIgnoreCase(answer)) {
                return true;
            }
            if ("no".equalsIgnoreCase(answer)) {
                return false;
            }
            answer = this.readLine("Please answer with yes or no: ", null);
        }
        return false;
    }
}

