/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.console.karaf.command;

import java.io.File;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.console.karaf.XipkiCommandSupport;
import org.xipki.console.karaf.completer.DirPathCompleter;
import org.xipki.console.karaf.intern.FileUtils;

@Command(scope="xi", name="copy-dir", description="copy content of the directory to destination")
@Service
public class CopyDirCmd
extends XipkiCommandSupport {
    @Argument(index=0, name="source directory", required=true, description="content of this directory will be copied\n(required)")
    @Completion(value=DirPathCompleter.class)
    private String source;
    @Argument(index=1, name="destination", required=true, description="destination directory\n(required)")
    @Completion(value=DirPathCompleter.class)
    private String dest;

    @Override
    protected Object execute0() throws Exception {
        File sourceDir = new File(CopyDirCmd.expandFilepath(this.source));
        if (!sourceDir.exists()) {
            System.err.println(this.source + " does not exist");
            return null;
        }
        if (!sourceDir.isDirectory()) {
            System.err.println(this.source + " is not a directory");
            return null;
        }
        File destDir = new File(this.dest);
        if (destDir.exists()) {
            if (destDir.isFile()) {
                System.err.println(this.dest + " is not a directory");
                return null;
            }
        } else {
            destDir.mkdirs();
        }
        FileUtils.copyDirectory(sourceDir, destDir);
        return null;
    }
}

