/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.console.karaf.command;

import java.io.File;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.console.karaf.XipkiCommandSupport;
import org.xipki.console.karaf.completer.FilePathCompleter;
import org.xipki.console.karaf.intern.FileUtils;

@Command(scope="xi", name="copy-file", description="copy file")
@Service
public class CopyFileCmd
extends XipkiCommandSupport {
    @Argument(index=0, name="source file", required=true, description="file to be copied\n(required)")
    @Completion(value=FilePathCompleter.class)
    private String source;
    @Argument(index=1, name="destination", required=true, description="destination directory or file\n(required)")
    @Completion(value=FilePathCompleter.class)
    private String dest;
    @Option(name="--force", aliases={"-f"}, description="override existing file, never prompt")
    private Boolean force = Boolean.FALSE;

    @Override
    protected Object execute0() throws Exception {
        File sourceFile = new File(CopyFileCmd.expandFilepath(this.source));
        if (!sourceFile.exists()) {
            System.err.println(this.source + " does not exist");
            return null;
        }
        if (!sourceFile.isFile()) {
            System.err.println(this.source + " is not a file");
            return null;
        }
        File destFile = new File(this.dest);
        if (destFile.exists()) {
            if (!destFile.isFile()) {
                System.err.println("cannot override an existing directory by a file");
                return null;
            }
            if (!this.force.booleanValue() && !this.confirm("Do you want to override the file " + this.dest, 3)) {
                return null;
            }
        } else {
            File parent = destFile.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
        }
        FileUtils.copyFile(sourceFile, destFile, true);
        return null;
    }
}

