/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.console.karaf.command;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.common.util.Base64;
import org.xipki.common.util.IoUtil;
import org.xipki.common.util.StringUtil;
import org.xipki.console.karaf.IllegalCmdParamException;
import org.xipki.console.karaf.XipkiCommandSupport;
import org.xipki.console.karaf.completer.FilePathCompleter;

@Command(scope="xi", name="curl", description="transfer a URL")
@Service
public class CurlCmd
extends XipkiCommandSupport {
    @Argument(index=0, name="url", required=true, description="URL\n(required)")
    private String url;
    @Option(name="--verbose", aliases={"-v"}, description="show request and response verbosely")
    private Boolean verbose = Boolean.FALSE;
    @Option(name="--post", aliases={"-p"}, description="send the request via HTTP POST")
    private Boolean usePost = Boolean.FALSE;
    @Option(name="--data", aliases={"-d"}, description="data to be sent in a POST request")
    private String postData;
    @Option(name="--data-charset", aliases={"-c"}, description="charset of data")
    private String postDataCharSet = "UTF-8";
    @Option(name="--data-file", description="file contains the data to be sent in a POST request")
    private String postDataFile;
    @Option(name="--out", description="where to save the response")
    @Completion(value=FilePathCompleter.class)
    private String outFile;
    @Option(name="--header", aliases={"-h"}, multiValued=true, description="header in request")
    @Completion(value=FilePathCompleter.class)
    private List<String> headers;
    @Option(name="--user", aliases={"-u"}, description="User and password of the form user:password")
    private String userPassword;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object execute0() throws Exception {
        byte[] dataBytes = null;
        if (this.postData != null) {
            dataBytes = this.postData.getBytes(this.postDataCharSet);
        } else if (this.postDataFile != null) {
            dataBytes = IoUtil.read((String)this.postDataFile);
        }
        if (dataBytes != null) {
            this.usePost = Boolean.TRUE;
        }
        URL newUrl = new URL(this.url);
        HttpURLConnection httpConn = IoUtil.openHttpConn((URL)newUrl);
        try {
            Map<String, List<String>> properties;
            httpConn.setRequestMethod(this.usePost != false ? "POST" : "GET");
            httpConn.setUseCaches(false);
            if (this.headers != null) {
                for (String header : this.headers) {
                    int idx = header.indexOf(58);
                    if (idx == -1 || idx == header.length() - 1) {
                        throw new IllegalCmdParamException("invalid HTTP header: '" + header + "'");
                    }
                    String key = header.substring(0, idx);
                    String value = header.substring(idx + 1).trim();
                    httpConn.setRequestProperty(key, value);
                }
            }
            if (this.userPassword != null) {
                int idx = this.userPassword.indexOf(58);
                if (idx == -1 || idx == this.userPassword.length() - 1) {
                    throw new IllegalCmdParamException("invalid user");
                }
                httpConn.setRequestProperty("Authorization", "Basic " + Base64.encodeToString((byte[])this.userPassword.getBytes()));
            }
            if (dataBytes == null) {
                properties = httpConn.getRequestProperties();
            } else {
                httpConn.setDoOutput(true);
                httpConn.setRequestProperty("Content-Length", Integer.toString(dataBytes.length));
                properties = httpConn.getRequestProperties();
                OutputStream outputstream = httpConn.getOutputStream();
                outputstream.write(dataBytes);
                outputstream.flush();
            }
            if (this.verbose.booleanValue()) {
                this.println("=====request=====");
                this.println("  HTTP method: " + httpConn.getRequestMethod());
                for (String key : properties.keySet()) {
                    List<String> values = properties.get(key);
                    for (String string : values) {
                        this.println("  " + key + ": " + string);
                    }
                }
            }
            int respCode = httpConn.getResponseCode();
            if (this.verbose.booleanValue()) {
                this.println("=====response=====");
                this.println("  response code: " + respCode + " " + httpConn.getResponseMessage());
                properties = httpConn.getHeaderFields();
                for (String key : properties.keySet()) {
                    if (key == null) continue;
                    List<String> values = properties.get(key);
                    for (String value : values) {
                        this.println("  " + key + ": " + value);
                    }
                }
                this.println("=====response content=====");
            } else if (respCode != 200) {
                this.println("ERROR: bad response: " + httpConn.getResponseCode() + "    " + httpConn.getResponseMessage());
            }
            InputStream inputStream = null;
            InputStream errorStream = null;
            try {
                inputStream = httpConn.getInputStream();
            }
            catch (IOException ex) {
                errorStream = httpConn.getErrorStream();
            }
            Object respContentBytes = inputStream != null ? IoUtil.read((InputStream)inputStream) : (Object)(errorStream != null ? IoUtil.read((InputStream)errorStream) : null);
            if (respContentBytes == null || ((byte[])respContentBytes).length == 0) {
                this.println("NO response content");
                Object var9_18 = null;
                return var9_18;
            }
            if (this.outFile != null) {
                String string = errorStream != null ? "error-" + this.outFile : this.outFile;
                this.saveVerbose("saved response to file", new File(string), (byte[])respContentBytes);
            } else {
                String string = httpConn.getHeaderField("Content-Type");
                String charset = CurlCmd.getCharset(string);
                if (charset == null) {
                    charset = "UTF-8";
                }
                if (errorStream != null) {
                    this.println("ERROR: ");
                }
                this.println(new String((byte[])respContentBytes, charset));
            }
        }
        finally {
            httpConn.disconnect();
        }
        return null;
    }

    private static String getCharset(String contentType) {
        if (StringUtil.isBlank((String)contentType) || contentType.indexOf(59) == -1) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(contentType, ";");
        st.nextToken();
        while (st.hasMoreTokens()) {
            String paramName;
            String token = st.nextToken();
            int idx = token.indexOf(61);
            if (idx == -1 || !"charset".equalsIgnoreCase(paramName = token.substring(0, idx).trim())) continue;
            return token.substring(idx + 1, token.length());
        }
        return null;
    }
}

