/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.console.karaf.command;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.console.karaf.IllegalCmdParamException;
import org.xipki.console.karaf.XipkiCommandSupport;
import org.xipki.console.karaf.completer.FilePathCompleter;

@Command(scope="xi", name="ls", description="list directory contents")
@Service
public class FileListCmd
extends XipkiCommandSupport {
    @Argument(index=0, name="file", required=true, description="file or directory\n(required)")
    @Completion(value=FilePathCompleter.class)
    private String targetPath;

    @Override
    protected Object execute0() throws Exception {
        File target = new File(FileListCmd.expandFilepath(this.targetPath));
        if (!target.exists()) {
            throw new IllegalCmdParamException("could not access " + this.targetPath + ": no such file or directory");
        }
        if (!target.isDirectory()) {
            this.print(this.targetPath);
            return null;
        }
        LinkedList<String> list = new LinkedList<String>();
        File[] children = target.listFiles();
        int maxLen = -1;
        if (children != null) {
            for (File child : children) {
                String name = child.getName();
                if (child.isDirectory()) {
                    name = name + File.separator;
                }
                list.add(name);
                maxLen = Math.max(maxLen, name.length());
            }
        }
        if (FileListCmd.isEmpty(list)) {
            return null;
        }
        Collections.sort(list);
        LinkedList<String> l2 = new LinkedList<String>();
        for (String s : list) {
            Object tmpS = s;
            int diffLen = maxLen - ((String)tmpS).length();
            if (diffLen > 0) {
                for (int i = 0; i < diffLen; ++i) {
                    tmpS = (String)tmpS + " ";
                }
            }
            l2.add((String)tmpS);
        }
        int width = this.session.getTerminal().getWidth();
        int n = width / (maxLen + 1);
        if (n == 0) {
            for (String s : l2) {
                this.print(s);
            }
        } else {
            for (int i = 0; i < l2.size(); i += n) {
                StringBuilder sb = new StringBuilder();
                for (int j = i; j < Math.min(l2.size(), i + n); ++j) {
                    sb.append((String)l2.get(j)).append(" ");
                }
                this.print(sb.toString());
            }
        }
        this.println("");
        return null;
    }
}

