/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.console.karaf.command;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.xipki.common.util.StringUtil;
import org.xipki.console.karaf.IllegalCmdParamException;
import org.xipki.console.karaf.XipkiCommandSupport;
import org.xipki.console.karaf.completer.PasswordNameCompleter;
import org.xipki.password.PasswordProducer;

@Command(scope="xi", name="produce-password", description="produce password")
@Service
public class ProducePasswordCmd
extends XipkiCommandSupport {
    @Option(name="--name", required=true, description="name of the password")
    @Completion(value=PasswordNameCompleter.class)
    private String name;
    @Option(name="-k", description="quorum of the password parts")
    private Integer quorum = 1;

    @Override
    protected Object execute0() throws Exception {
        if (!PasswordProducer.needsPassword((String)this.name)) {
            throw new IllegalCmdParamException("password named '" + this.name + "' will not be requested");
        }
        block0: while (PasswordProducer.needsPassword((String)this.name)) {
            int i;
            char[] password;
            if (this.quorum == 1) {
                password = this.readPassword("Password");
            } else {
                char[][] parts = new char[this.quorum.intValue()][];
                for (i = 0; i < this.quorum; ++i) {
                    parts[i] = this.readPassword("Password (part " + (i + 1) + "/" + this.quorum + ")");
                }
                password = StringUtil.merge((char[][])parts);
            }
            PasswordProducer.putPassword((String)this.name, (char[])password);
            int n = 10;
            for (i = 0; i < 10; ++i) {
                Thread.sleep(500L);
                Boolean correct = PasswordProducer.removePasswordCorrect((String)this.name);
                if (correct != null) {
                    this.println("\rthe given password is " + (correct != false ? "correct            " : "not correct        "));
                    continue block0;
                }
                this.println("\rthe given password is still under process");
            }
        }
        return null;
    }
}

