/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.console.karaf.intern;

import java.io.File;
import java.nio.charset.Charset;

public class Configuration {
    private Configuration() {
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static File getUserHome() {
        return new File(System.getProperty("user.home"));
    }

    public static String getOsName() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static boolean isWindows() {
        return Configuration.getOsName().startsWith("windows");
    }

    public static String getFileEncoding() {
        return System.getProperty("file.encoding");
    }

    public static String getEncoding() {
        String envEncoding = Configuration.extractEncodingFromCtype(System.getenv("LC_CTYPE"));
        if (envEncoding != null) {
            return envEncoding;
        }
        return System.getProperty("input.encoding", Charset.defaultCharset().name());
    }

    static String extractEncodingFromCtype(String ctype) {
        if (ctype != null && ctype.indexOf(46) > 0) {
            String encodingAndModifier = ctype.substring(ctype.indexOf(46) + 1);
            return encodingAndModifier.indexOf(64) > 0 ? encodingAndModifier.substring(0, encodingAndModifier.indexOf(64)) : encodingAndModifier;
        }
        return null;
    }
}

