/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.apppackage;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.xipki.apppackage.JSON;
import org.xipki.apppackage.PackageInfo;
import org.xipki.apppackage.PackageInfoBuilder;

public class CompressPackage {
    private final boolean isPosix;
    private final MessageDigest sha256;
    private final Map<String, Integer> posixPermissions = new HashMap<String, Integer>();

    public CompressPackage(File confFile) {
        try {
            this.sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.isPosix = FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        Properties properties = new Properties();
        if (confFile != null) {
            try (InputStream is = Files.newInputStream(confFile.toPath(), new OpenOption[0]);){
                properties.load(is);
                for (String key : properties.stringPropertyNames()) {
                    String value = properties.getProperty(key);
                    int intPermission = Integer.parseInt(value);
                    this.posixPermissions.put(Paths.get(key, new String[0]).toFile().getCanonicalPath(), intPermission);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void main(String[] args) {
        try {
            if (args == null || args.length != 3) {
                System.out.println("Usage: java " + CompressPackage.class.getName() + " <conf-file> <source dir> <dest dir>");
                System.exit(1);
            }
            File confFile = new File(args[0]);
            File srcDir = new File(args[1]);
            File destDir = new File(args[2]);
            new CompressPackage(confFile).compressDir(srcDir, destDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void compressDir(File srcDir, File targetDir) throws Exception {
        if (targetDir.toPath().startsWith(srcDir.toPath())) {
            throw new IllegalArgumentException("targetDir must not be under srcDir");
        }
        if (targetDir.exists()) {
            throw new IllegalArgumentException("targetDir already exists");
        }
        PackageInfoBuilder builder = new PackageInfoBuilder();
        targetDir.mkdirs();
        this.compressDir(builder, srcDir.toPath(), srcDir, targetDir);
        PackageInfo packageInfo = builder.build();
        byte[] packageInfoBytes = JSON.toJSONBytes(packageInfo);
        byte[] packageInfoSha256 = this.sha256.digest(packageInfoBytes);
        Files.copy(new ByteArrayInputStream(packageInfoBytes), new File(targetDir, "meta-info.json").toPath(), new CopyOption[0]);
        Files.copy(new ByteArrayInputStream(packageInfoSha256), new File(targetDir, "meta-info.json.sha256").toPath(), new CopyOption[0]);
    }

    private void compressDir(PackageInfoBuilder packageInfoBuilder, Path baseSrcDir, File srcDir, File targetDir) throws Exception {
        File[] subDirsOrFiles;
        for (File subDirOrFile : subDirsOrFiles = srcDir.listFiles()) {
            if (subDirOrFile.isDirectory()) {
                packageInfoBuilder.addFolder(baseSrcDir, subDirOrFile.toPath());
                this.compressDir(packageInfoBuilder, baseSrcDir, subDirOrFile, targetDir);
                continue;
            }
            this.compressFile(packageInfoBuilder, baseSrcDir, subDirOrFile, targetDir);
        }
    }

    private void compressFile(PackageInfoBuilder packageInfoBuilder, Path baseSrcDir, File file, File targetDir) throws Exception {
        Integer posixPermission;
        Path filePath;
        Path relativePath;
        byte[] fileBytes = Files.readAllBytes(file.toPath());
        byte[] sha256Value = this.sha256.digest(fileBytes);
        boolean newEntry = packageInfoBuilder.addFile(sha256Value, relativePath = (filePath = file.toPath()).subpath(baseSrcDir.getNameCount(), filePath.getNameCount()), posixPermission = this.posixPermissions.get(relativePath.toFile().getCanonicalPath()));
        if (newEntry) {
            File newEntryFile = new File(targetDir, PackageInfoBuilder.bytesToHex(sha256Value));
            Files.copy(file.toPath(), newEntryFile.toPath(), new CopyOption[0]);
        }
    }
}

