/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.apppackage;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xipki.apppackage.FileInfo;
import org.xipki.apppackage.PackageInfo;
import org.xipki.apppackage.PathInfo;

public class PackageInfoBuilder {
    private static final String pathSep = File.separator;
    private final List<String> folders = new LinkedList<String>();
    private final Map<String, FileInfo> files = new HashMap<String, FileInfo>();
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public void addFolder(Path baseSrcDir, Path folder) {
        String path = folder.subpath(baseSrcDir.getNameCount(), folder.getNameCount()).toString();
        if (!pathSep.equals("/")) {
            path = path.replace(pathSep, "/");
        }
        this.folders.add(path);
    }

    public boolean addFile(byte[] sha256, Path relativePath, Integer intPermission) {
        String hexSha256 = PackageInfoBuilder.bytesToHex(sha256);
        FileInfo fileInfo = this.files.get(hexSha256);
        boolean newEntry = false;
        if (fileInfo == null) {
            fileInfo = new FileInfo();
            fileInfo.setPathInfos(new LinkedList<PathInfo>());
            fileInfo.setSha256(hexSha256);
            this.files.put(hexSha256, fileInfo);
            newEntry = true;
        }
        PathInfo pathInfo = new PathInfo();
        fileInfo.getPathInfos().add(pathInfo);
        String path = relativePath.toString();
        if (!pathSep.equals("/")) {
            path = path.replace(pathSep, "/");
        }
        pathInfo.setPath(path);
        if (intPermission != null) {
            pathInfo.setUnixPermissions(intPermission);
        }
        return newEntry;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public PackageInfo build() {
        PackageInfo packageInfo = new PackageInfo();
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>(this.files.size());
        for (Map.Entry<String, FileInfo> entry : this.files.entrySet()) {
            fileInfos.add(entry.getValue());
        }
        packageInfo.setFiles(fileInfos);
        packageInfo.setFolders(this.folders);
        return packageInfo;
    }
}

