/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.apppackage;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xipki.apppackage.MyUtil;

public class PackageConf {
    private List<String> unpackZipFiles;
    private Map<String, Integer> posixPermissions;

    public List<String> getUnpackZipFiles() {
        return this.unpackZipFiles;
    }

    public void setUnpackZipFiles(List<String> unpackZipFiles) {
        this.unpackZipFiles = unpackZipFiles;
    }

    public Map<String, Integer> getPosixPermissions() {
        return this.posixPermissions;
    }

    public void setPosixPermissions(Map<String, Integer> posixPermissions) {
        this.posixPermissions = posixPermissions;
    }

    public void init() {
        Cloneable canonicalPaths;
        if (this.unpackZipFiles == null) {
            this.unpackZipFiles = new ArrayList<String>(1);
        } else {
            canonicalPaths = new ArrayList<String>(this.unpackZipFiles.size());
            for (String string : this.unpackZipFiles) {
                canonicalPaths.add((String)MyUtil.toUnixPath(string));
            }
            this.unpackZipFiles = canonicalPaths;
        }
        if (this.posixPermissions == null) {
            this.posixPermissions = new HashMap<String, Integer>(1);
        } else {
            canonicalPaths = new HashMap(this.posixPermissions.size());
            for (Map.Entry entry : this.posixPermissions.entrySet()) {
                canonicalPaths.put(MyUtil.toUnixPath((String)entry.getKey()), (Integer)entry.getValue());
            }
            this.posixPermissions = canonicalPaths;
        }
    }

    public boolean unzipMe(Path baseDir, Path zipFilePath) {
        String canonicalPath = MyUtil.toUnixPath(baseDir, zipFilePath);
        return this.unpackZipFiles.contains(canonicalPath);
    }

    public Integer posixPermission(Path baseDir, Path filePath) {
        String canonicalPath = MyUtil.toUnixPath(baseDir, filePath);
        return this.posixPermissions.get(canonicalPath);
    }
}

