/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.apppackage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xipki.apppackage.MyUtil;
import org.xipki.apppackage.PathInfo;
import org.xipki.apppackage.jacob.CborDecoder;
import org.xipki.apppackage.jacob.CborEncoder;

public class FileInfo {
    private String sha256;
    private int size;
    private List<PathInfo> pathInfos;

    public String getSha256() {
        return this.sha256;
    }

    public void setSha256(String sha256) {
        this.sha256 = sha256;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public List<PathInfo> getPathInfos() {
        return this.pathInfos;
    }

    public void setPathInfos(List<PathInfo> pathInfos) {
        this.pathInfos = pathInfos;
    }

    public void encode(CborEncoder encoder) throws IOException {
        encoder.writeArrayStart(3);
        encoder.writeTextString(this.sha256);
        encoder.writeInt(this.size);
        if (this.pathInfos == null) {
            encoder.writeNull();
        } else {
            encoder.writeArrayStart(this.pathInfos.size());
            for (PathInfo pathInfo : this.pathInfos) {
                pathInfo.encode(encoder);
            }
        }
    }

    public static FileInfo decode(CborDecoder decoder) throws IOException {
        ArrayList<PathInfo> pathInfos;
        MyUtil.readArrayStart(3, decoder);
        FileInfo ret = new FileInfo();
        ret.setSha256(decoder.readTextString());
        ret.setSize((int)decoder.readInt());
        if (MyUtil.isNull(decoder)) {
            decoder.readNull();
            pathInfos = null;
        } else {
            int size = (int)decoder.readArrayLength();
            pathInfos = new ArrayList<PathInfo>(size);
            for (int i = 0; i < size; ++i) {
                pathInfos.add(PathInfo.decode(decoder));
            }
        }
        ret.setPathInfos(pathInfos);
        return ret;
    }
}

