/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.apppackage;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xipki.apppackage.jacob.CborDecoder;
import org.xipki.apppackage.jacob.CborType;

public class MyUtil {
    private static final String pathSep = File.separator;
    private static final boolean isPosix;
    private static final MessageDigest sha256;
    private static final char[] HEX_ARRAY;

    public static boolean isIsPosix() {
        return isPosix;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String hexSha256(byte[] bytes) {
        MessageDigest messageDigest = sha256;
        synchronized (messageDigest) {
            return MyUtil.bytesToHex(sha256.digest(bytes));
        }
    }

    public static String toUnixPath(String path) {
        if (!pathSep.equals("/")) {
            path = path.replace(pathSep, "/");
        }
        return path;
    }

    public static String toUnixPath(Path basePath, Path path) {
        if (path.startsWith(basePath)) {
            Path relativePath = path.subpath(basePath.getNameCount(), path.getNameCount());
            return MyUtil.toUnixPath(relativePath.toString());
        }
        return MyUtil.toUnixPath(path.toString());
    }

    public static Set<PosixFilePermission> toPosixFilePermissions(int intPermission) {
        int otherPermission = intPermission % 10;
        int groupPermission = intPermission / 10 % 10;
        int ownerPermission = intPermission / 100 % 10;
        HashSet<PosixFilePermission> filePermissions = new HashSet<PosixFilePermission>();
        if ((otherPermission & 1) != 0) {
            filePermissions.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        if ((otherPermission & 2) != 0) {
            filePermissions.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((otherPermission & 4) != 0) {
            filePermissions.add(PosixFilePermission.OTHERS_READ);
        }
        if ((groupPermission & 1) != 0) {
            filePermissions.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((groupPermission & 2) != 0) {
            filePermissions.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((groupPermission & 4) != 0) {
            filePermissions.add(PosixFilePermission.GROUP_READ);
        }
        if ((ownerPermission & 1) != 0) {
            filePermissions.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((ownerPermission & 2) != 0) {
            filePermissions.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((ownerPermission & 4) != 0) {
            filePermissions.add(PosixFilePermission.OWNER_READ);
        }
        return filePermissions;
    }

    public static boolean isNull(CborDecoder decoder) throws IOException {
        CborType type = decoder.peekType();
        return type.getMajorType() == 7 && type.getAdditionalInfo() == 22;
    }

    public static String readText(CborDecoder decoder) throws IOException {
        if (MyUtil.isNull(decoder)) {
            decoder.readNull();
            return null;
        }
        return decoder.readTextString();
    }

    public static Long readLong(CborDecoder decoder) throws IOException {
        if (MyUtil.isNull(decoder)) {
            decoder.readNull();
            return null;
        }
        return decoder.readInt();
    }

    public static byte[] readByteString(CborDecoder decoder) throws IOException {
        if (MyUtil.isNull(decoder)) {
            decoder.readNull();
            return null;
        }
        return decoder.readByteString();
    }

    public static List<String> readTextList(CborDecoder decoder) throws IOException {
        if (MyUtil.isNull(decoder)) {
            decoder.readNull();
            return null;
        }
        int size = (int)decoder.readArrayLength();
        ArrayList<String> list = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            list.add(decoder.readTextString());
        }
        return list;
    }

    public static int readArrayStart(int expectedArrayLen, CborDecoder decoder) throws IOException {
        int arrayLen = (int)decoder.readArrayLength();
        if (arrayLen != expectedArrayLen) {
            throw new IOException("array.length is " + arrayLen + " but expected " + expectedArrayLen);
        }
        return arrayLen;
    }

    static {
        HEX_ARRAY = "0123456789ABCDEF".toCharArray();
        try {
            sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        isPosix = FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
    }
}

