/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.apppackage;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.xipki.apppackage.MyUtil;

public class PackageConf {
    private List<String> unpackZipFiles;
    private Map<String, Integer> posixPermissions;

    public List<String> getUnpackZipFiles() {
        return this.unpackZipFiles;
    }

    public void setUnpackZipFiles(List<String> unpackZipFiles) {
        this.unpackZipFiles = unpackZipFiles;
    }

    public Map<String, Integer> getPosixPermissions() {
        return this.posixPermissions;
    }

    public void setPosixPermissions(Map<String, Integer> posixPermissions) {
        this.posixPermissions = posixPermissions;
    }

    public PackageConf(File confFile) throws IOException {
        Properties props = new Properties();
        try (FileReader reader = new FileReader(confFile);){
            props.load(reader);
        }
        String value = props.getProperty("unpackZipFiles");
        if (value == null) {
            this.unpackZipFiles = new ArrayList<String>(1);
        } else {
            String[] _unpackZipFiles = value.split(", ");
            this.unpackZipFiles = new ArrayList<String>(_unpackZipFiles.length);
            for (String path : _unpackZipFiles) {
                this.unpackZipFiles.add(MyUtil.toUnixPath(path));
            }
        }
        value = props.getProperty("posixPermissions");
        if (value == null) {
            this.posixPermissions = new HashMap<String, Integer>(1);
        } else {
            String[] _posixPermissions = value.split(", ");
            this.posixPermissions = new HashMap<String, Integer>(_posixPermissions.length);
            for (String permission : _posixPermissions) {
                String[] tokens = permission.split(":");
                this.posixPermissions.put(MyUtil.toUnixPath(tokens[0]), Integer.parseInt(tokens[1]));
            }
        }
    }

    public boolean unzipMe(Path baseDir, Path zipFilePath) {
        String canonicalPath = MyUtil.toUnixPath(baseDir, zipFilePath);
        return this.unpackZipFiles.contains(canonicalPath);
    }

    public Integer posixPermission(Path baseDir, Path filePath) {
        String canonicalPath = MyUtil.toUnixPath(baseDir, filePath);
        return this.posixPermissions.get(canonicalPath);
    }
}

