/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.apppackage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xipki.apppackage.FileInfo;
import org.xipki.apppackage.MyUtil;
import org.xipki.apppackage.ZipFileInfo;
import org.xipki.apppackage.jacob.CborDecoder;
import org.xipki.apppackage.jacob.CborEncoder;

public class PackageInfo {
    private List<String> folders;
    private List<ZipFileInfo> zipFiles;
    private List<FileInfo> files;

    public List<String> getFolders() {
        return this.folders;
    }

    public void setFolders(List<String> folders) {
        this.folders = folders;
    }

    public List<FileInfo> getFiles() {
        return this.files;
    }

    public void setFiles(List<FileInfo> files) {
        this.files = files;
    }

    public List<ZipFileInfo> getZipFiles() {
        return this.zipFiles;
    }

    public void setZipFiles(List<ZipFileInfo> zipFiles) {
        this.zipFiles = zipFiles;
    }

    public byte[] encode() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        CborEncoder encoder = new CborEncoder(bout);
        encoder.writeArrayStart(3);
        if (this.folders == null) {
            encoder.writeNull();
        } else {
            encoder.writeArrayStart(this.folders.size());
            for (String folder : this.folders) {
                encoder.writeTextString(folder);
            }
        }
        if (this.zipFiles == null) {
            encoder.writeNull();
        } else {
            encoder.writeArrayStart(this.zipFiles.size());
            for (ZipFileInfo zipFile : this.zipFiles) {
                zipFile.encode(encoder);
            }
        }
        if (this.files == null) {
            encoder.writeNull();
        } else {
            encoder.writeArrayStart(this.files.size());
            for (FileInfo file : this.files) {
                file.encode(encoder);
            }
        }
        bout.flush();
        return bout.toByteArray();
    }

    public static PackageInfo decode(byte[] encoded) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(encoded);){
            ArrayList<FileInfo> files;
            ArrayList<ZipFileInfo> zipFiles;
            CborDecoder decoder = new CborDecoder(is);
            MyUtil.readArrayStart(3, decoder);
            List<String> folders = MyUtil.readTextList(decoder);
            if (MyUtil.isNull(decoder)) {
                decoder.readNull();
                zipFiles = null;
            } else {
                int size = (int)decoder.readArrayLength();
                zipFiles = new ArrayList<ZipFileInfo>(size);
                for (int i = 0; i < size; ++i) {
                    zipFiles.add(ZipFileInfo.decode(decoder));
                }
            }
            if (MyUtil.isNull(decoder)) {
                decoder.readNull();
                files = null;
            } else {
                int size = (int)decoder.readArrayLength();
                files = new ArrayList<FileInfo>(size);
                for (int i = 0; i < size; ++i) {
                    files.add(FileInfo.decode(decoder));
                }
            }
            PackageInfo pi = new PackageInfo();
            pi.setFolders(folders);
            pi.setZipFiles(zipFiles);
            pi.setFiles(files);
            PackageInfo packageInfo = pi;
            return packageInfo;
        }
    }
}

