/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.apppackage;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xipki.apppackage.FileInfo;
import org.xipki.apppackage.MyUtil;
import org.xipki.apppackage.PackageInfo;
import org.xipki.apppackage.PathInfo;
import org.xipki.apppackage.ZipFileInfo;

public class PackageInfoBuilder {
    private final List<String> folders = new LinkedList<String>();
    private final List<ZipFileInfo> zipFiles = new LinkedList<ZipFileInfo>();
    private final Map<String, FileInfo> files = new HashMap<String, FileInfo>();

    public void addFolder(Path baseSrcDir, Path folder) {
        this.folders.add(MyUtil.toUnixPath(baseSrcDir, folder));
    }

    public void addZipFile(ZipFileInfo zipFileInfo) {
        this.zipFiles.add(zipFileInfo);
    }

    public void addFile(byte[] bytes, long lastModified, Path relativePath, Integer intPermission, File targetDir) throws IOException {
        String hexSha256 = MyUtil.hexSha256(bytes);
        FileInfo fileInfo = this.files.get(hexSha256);
        if (fileInfo == null) {
            fileInfo = new FileInfo();
            fileInfo.setPathInfos(new LinkedList<PathInfo>());
            fileInfo.setSha256(hexSha256);
            fileInfo.setSize(bytes.length);
            this.files.put(hexSha256, fileInfo);
            File newEntryFile = new File(targetDir, hexSha256);
            Files.copy(new ByteArrayInputStream(bytes), newEntryFile.toPath(), new CopyOption[0]);
        }
        PathInfo pathInfo = new PathInfo();
        fileInfo.getPathInfos().add(pathInfo);
        pathInfo.setPath(relativePath.toString());
        pathInfo.setLastModified(lastModified / 1000L);
        if (intPermission != null) {
            pathInfo.setPosixPermissions(intPermission);
        }
    }

    public String addZipEntry(byte[] bytes, String name, File targetDir) throws IOException {
        String hexSha256 = MyUtil.hexSha256(bytes);
        FileInfo fileInfo = this.files.get(hexSha256);
        if (fileInfo == null) {
            fileInfo = new FileInfo();
            fileInfo.setPathInfos(new LinkedList<PathInfo>());
            fileInfo.setSha256(hexSha256);
            fileInfo.setSize(bytes.length);
            this.files.put(hexSha256, fileInfo);
            File newEntryFile = new File(targetDir, hexSha256);
            Files.copy(new ByteArrayInputStream(bytes), newEntryFile.toPath(), new CopyOption[0]);
        }
        String path = "zip:" + name;
        List<PathInfo> pathInfos = fileInfo.getPathInfos();
        boolean contained = false;
        for (PathInfo pathInfo : pathInfos) {
            if (!pathInfo.getPath().equals(path)) continue;
            contained = true;
            break;
        }
        if (!contained) {
            PathInfo pathInfo = new PathInfo();
            pathInfo.setPath("zip:" + name);
            pathInfos.add(pathInfo);
        }
        return hexSha256;
    }

    public PackageInfo build() {
        PackageInfo packageInfo = new PackageInfo();
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>(this.files.size());
        for (Map.Entry<String, FileInfo> entry : this.files.entrySet()) {
            fileInfos.add(entry.getValue());
        }
        packageInfo.setFiles(fileInfos);
        packageInfo.setFolders(this.folders);
        if (!this.zipFiles.isEmpty()) {
            packageInfo.setZipFiles(this.zipFiles);
        }
        return packageInfo;
    }
}

