/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.apppackage;

import java.io.IOException;
import org.xipki.apppackage.MyUtil;
import org.xipki.apppackage.jacob.CborDecoder;
import org.xipki.apppackage.jacob.CborEncoder;

public class ZipEntryInfo {
    private String name;
    private int size;
    private String comment;
    private long lastModified;
    private String sha256;
    private byte[] extra;

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public void setExtra(byte[] extra) {
        this.extra = extra;
    }

    public String getSha256() {
        return this.sha256;
    }

    public void setSha256(String sha256) {
        this.sha256 = sha256;
    }

    public void encode(CborEncoder encoder) throws IOException {
        encoder.writeArrayStart(6);
        encoder.writeTextString(this.name);
        encoder.writeInt(this.size);
        if (this.comment == null) {
            encoder.writeNull();
        } else {
            encoder.writeTextString(this.comment);
        }
        encoder.writeInt(this.lastModified);
        encoder.writeTextString(this.sha256);
        if (this.extra == null) {
            encoder.writeNull();
        } else {
            encoder.writeByteString(this.extra);
        }
    }

    public static ZipEntryInfo decode(CborDecoder decoder) throws IOException {
        MyUtil.readArrayStart(6, decoder);
        ZipEntryInfo ret = new ZipEntryInfo();
        ret.setName(decoder.readTextString());
        ret.setSize((int)decoder.readInt());
        ret.setComment(MyUtil.readText(decoder));
        ret.setLastModified(decoder.readInt());
        ret.setSha256(decoder.readTextString());
        ret.setExtra(MyUtil.readByteString(decoder));
        return ret;
    }
}

