/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.apppackage.jacob;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.xipki.apppackage.jacob.CborType;

public class CborDecoder {
    protected final PushbackInputStream m_is;

    public CborDecoder(InputStream is) {
        if (is == null) {
            throw new IllegalArgumentException("InputStream cannot be null!");
        }
        this.m_is = is instanceof PushbackInputStream ? (PushbackInputStream)is : new PushbackInputStream(is);
    }

    private static void fail(String msg, Object ... args) throws IOException {
        throw new IOException(String.format(msg, args));
    }

    private static String lengthToString(int len) {
        return len < 0 ? "no payload" : (len == 24 ? "one byte" : (len == 25 ? "two bytes" : (len == 26 ? "four bytes" : (len == 27 ? "eight bytes" : "(unknown)"))));
    }

    public CborType peekType() throws IOException {
        int p = this.m_is.read();
        if (p < 0) {
            return null;
        }
        this.m_is.unread(p);
        return CborType.valueOf(p);
    }

    public long readArrayLength() throws IOException {
        return this.readMajorTypeWithSize(4);
    }

    public boolean readBoolean() throws IOException {
        int b = this.readMajorType(7);
        if (b != 20 && b != 21) {
            CborDecoder.fail("Unexpected boolean value: %d!", b);
        }
        return b == 21;
    }

    public Object readBreak() throws IOException {
        this.readMajorTypeExact(7, 31);
        return null;
    }

    public byte[] readByteString() throws IOException {
        long len = this.readMajorTypeWithSize(2);
        if (len < 0L) {
            CborDecoder.fail("Infinite-length byte strings not supported!", new Object[0]);
        }
        if (len > Integer.MAX_VALUE) {
            CborDecoder.fail("String length too long!", new Object[0]);
        }
        return this.readFully(new byte[(int)len]);
    }

    public long readByteStringLength() throws IOException {
        return this.readMajorTypeWithSize(2);
    }

    public double readDouble() throws IOException {
        this.readMajorTypeExact(7, 27);
        return Double.longBitsToDouble(this.readUInt64());
    }

    public float readFloat() throws IOException {
        this.readMajorTypeExact(7, 26);
        return Float.intBitsToFloat((int)this.readUInt32());
    }

    public double readHalfPrecisionFloat() throws IOException {
        this.readMajorTypeExact(7, 25);
        int half = this.readUInt16();
        int exp = half >> 10 & 0x1F;
        int mant = half & 0x3FF;
        double val = exp == 0 ? (double)mant * Math.pow(2.0, -24.0) : (exp != 31 ? (double)(mant + 1024) * Math.pow(2.0, exp - 25) : (mant != 0 ? Double.NaN : Double.POSITIVE_INFINITY));
        return (half & 0x8000) == 0 ? val : -val;
    }

    public long readInt() throws IOException {
        int ib = this.m_is.read();
        long ui = this.expectIntegerType(ib);
        return ui ^ this.readUInt(ib & 0x1F, false);
    }

    public int readInt16() throws IOException {
        int ib = this.m_is.read();
        long ui = this.expectIntegerType(ib);
        return (int)(ui ^ this.readUIntExact(25, ib & 0x1F));
    }

    public long readInt32() throws IOException {
        int ib = this.m_is.read();
        long ui = this.expectIntegerType(ib);
        return ui ^ this.readUIntExact(26, ib & 0x1F);
    }

    public long readInt64() throws IOException {
        int ib = this.m_is.read();
        long ui = this.expectIntegerType(ib);
        return ui ^ this.readUIntExact(27, ib & 0x1F);
    }

    public int readInt8() throws IOException {
        int ib = this.m_is.read();
        long ui = this.expectIntegerType(ib);
        return (int)(ui ^ this.readUIntExact(24, ib & 0x1F));
    }

    public long readMapLength() throws IOException {
        return this.readMajorTypeWithSize(5);
    }

    public Object readNull() throws IOException {
        this.readMajorTypeExact(7, 22);
        return null;
    }

    public byte readSimpleValue() throws IOException {
        this.readMajorTypeExact(7, 24);
        return (byte)this.readUInt8();
    }

    public int readSmallInt() throws IOException {
        int ib = this.m_is.read();
        long ui = this.expectIntegerType(ib);
        return (int)(ui ^ this.readUIntExact(-1, ib & 0x1F));
    }

    public long readTag() throws IOException {
        return this.readUInt(this.readMajorType(6), false);
    }

    public String readTextString() throws IOException {
        long len = this.readMajorTypeWithSize(3);
        if (len < 0L) {
            CborDecoder.fail("Infinite-length text strings not supported!", new Object[0]);
        }
        if (len > Integer.MAX_VALUE) {
            CborDecoder.fail("String length too long!", new Object[0]);
        }
        return new String(this.readFully(new byte[(int)len]), "UTF-8");
    }

    public long readTextStringLength() throws IOException {
        return this.readMajorTypeWithSize(3);
    }

    public Object readUndefined() throws IOException {
        this.readMajorTypeExact(7, 23);
        return null;
    }

    protected long expectIntegerType(int ib) throws IOException {
        int majorType = (ib & 0xFF) >>> 5;
        if (majorType != 0 && majorType != 1) {
            CborDecoder.fail("Unexpected type: %s, expected type %s or %s!", CborType.getName(majorType), CborType.getName(0), CborType.getName(1));
        }
        return -majorType;
    }

    protected int readMajorType(int majorType) throws IOException {
        int ib = this.m_is.read();
        if (majorType != (ib >>> 5 & 7)) {
            CborDecoder.fail("Unexpected type: %s, expected: %s!", CborType.getName(ib), CborType.getName(majorType));
        }
        return ib & 0x1F;
    }

    protected void readMajorTypeExact(int majorType, int subtype) throws IOException {
        int st = this.readMajorType(majorType);
        if ((st ^ subtype) != 0) {
            CborDecoder.fail("Unexpected subtype: %d, expected: %d!", st, subtype);
        }
    }

    protected long readMajorTypeWithSize(int majorType) throws IOException {
        return this.readUInt(this.readMajorType(majorType), true);
    }

    protected long readUInt(int length, boolean breakAllowed) throws IOException {
        long result = -1L;
        if (length < 24) {
            result = length;
        } else if (length == 24) {
            result = this.readUInt8();
        } else if (length == 25) {
            result = this.readUInt16();
        } else if (length == 26) {
            result = this.readUInt32();
        } else if (length == 27) {
            result = this.readUInt64();
        } else if (breakAllowed && length == 31) {
            return -1L;
        }
        if (result < 0L) {
            CborDecoder.fail("Not well-formed CBOR integer found, invalid length: %d!", result);
        }
        return result;
    }

    protected int readUInt16() throws IOException {
        byte[] buf = this.readFully(new byte[2]);
        return (buf[0] & 0xFF) << 8 | buf[1] & 0xFF;
    }

    protected long readUInt32() throws IOException {
        byte[] buf = this.readFully(new byte[4]);
        return (long)((buf[0] & 0xFF) << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | buf[3] & 0xFF) & 0xFFFFFFFFL;
    }

    protected long readUInt64() throws IOException {
        byte[] buf = this.readFully(new byte[8]);
        return ((long)buf[0] & 0xFFL) << 56 | ((long)buf[1] & 0xFFL) << 48 | ((long)buf[2] & 0xFFL) << 40 | ((long)buf[3] & 0xFFL) << 32 | ((long)buf[4] & 0xFFL) << 24 | ((long)buf[5] & 0xFFL) << 16 | ((long)buf[6] & 0xFFL) << 8 | (long)buf[7] & 0xFFL;
    }

    protected int readUInt8() throws IOException {
        return this.m_is.read() & 0xFF;
    }

    protected long readUIntExact(int expectedLength, int length) throws IOException {
        if (expectedLength == -1 && length >= 24 || expectedLength >= 0 && length != expectedLength) {
            CborDecoder.fail("Unexpected payload/length! Expected %s, but got %s.", CborDecoder.lengthToString(expectedLength), CborDecoder.lengthToString(length));
        }
        return this.readUInt(length, false);
    }

    private byte[] readFully(byte[] buf) throws IOException {
        int count;
        int len = buf.length;
        int off = 0;
        for (int n = 0; n < len; n += count) {
            count = this.m_is.read(buf, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
        return buf;
    }
}

