/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.apppackage.jacob;

import java.io.IOException;
import java.io.OutputStream;

public class CborEncoder {
    private static final int NEG_INT_MASK = 32;
    private final OutputStream m_os;

    public CborEncoder(OutputStream os) {
        if (os == null) {
            throw new IllegalArgumentException("OutputStream cannot be null!");
        }
        this.m_os = os;
    }

    static int halfPrecisionToRawIntBits(float fval) {
        int fbits = Float.floatToIntBits(fval);
        int sign = fbits >>> 16 & 0x8000;
        int val = (fbits & Integer.MAX_VALUE) + 4096;
        if (val >= 1199570944) {
            if ((fbits & Integer.MAX_VALUE) >= 1199570944) {
                if (val < 2139095040) {
                    return sign | 0x7C00;
                }
                return sign | 0x7C00 | (fbits & 0x7FFFFF) >>> 13;
            }
            return sign | 0x7BFF;
        }
        if (val >= 0x38800000) {
            return sign | val - 0x38000000 >>> 13;
        }
        if (val < 0x33000000) {
            return sign;
        }
        val = (fbits & Integer.MAX_VALUE) >>> 23;
        return sign | (fbits & 0x7FFFFF | 0x800000) + (0x800000 >>> val - 102) >>> 126 - val;
    }

    public void writeArrayStart() throws IOException {
        this.writeSimpleType(4, 31);
    }

    public void writeArrayStart(int length) throws IOException {
        if (length < 0) {
            throw new IllegalArgumentException("Invalid array-length!");
        }
        this.writeType(4, length);
    }

    public void writeBoolean(boolean value) throws IOException {
        this.writeSimpleType(7, value ? 21 : 20);
    }

    public void writeBreak() throws IOException {
        this.writeSimpleType(7, 31);
    }

    public void writeByteString(byte[] bytes) throws IOException {
        this.writeString(2, bytes);
    }

    public void writeByteStringStart() throws IOException {
        this.writeSimpleType(2, 31);
    }

    public void writeDouble(double value) throws IOException {
        this.writeUInt64(224, Double.doubleToRawLongBits(value));
    }

    public void writeFloat(float value) throws IOException {
        this.writeUInt32(224, Float.floatToRawIntBits(value));
    }

    public void writeHalfPrecisionFloat(float value) throws IOException {
        this.writeUInt16(224, CborEncoder.halfPrecisionToRawIntBits(value));
    }

    public void writeInt(long value) throws IOException {
        long sign = value >> 63;
        int mt = (int)(sign & 0x20L);
        value = sign ^ value;
        this.writeUInt(mt, value);
    }

    public void writeInt16(int value) throws IOException {
        int sign = value >> 31;
        int mt = sign & 0x20;
        this.writeUInt16(mt, (sign ^ value) & 0xFFFF);
    }

    public void writeInt32(long value) throws IOException {
        long sign = value >> 63;
        int mt = (int)(sign & 0x20L);
        this.writeUInt32(mt, (int)((sign ^ value) & 0xFFFFFFFFL));
    }

    public void writeInt64(long value) throws IOException {
        long sign = value >> 63;
        int mt = (int)(sign & 0x20L);
        this.writeUInt64(mt, sign ^ value);
    }

    public void writeInt8(int value) throws IOException {
        int sign = value >> 31;
        int mt = sign & 0x20;
        this.writeUInt8(mt, (sign ^ value) & 0xFF);
    }

    public void writeMapStart() throws IOException {
        this.writeSimpleType(5, 31);
    }

    public void writeMapStart(int length) throws IOException {
        if (length < 0) {
            throw new IllegalArgumentException("Invalid length of map!");
        }
        this.writeType(5, length);
    }

    public void writeNull() throws IOException {
        this.writeSimpleType(7, 22);
    }

    public void writeSimpleValue(byte simpleValue) throws IOException {
        int value = simpleValue & 0xFF;
        this.writeType(7, value);
    }

    public void writeSmallInt(int value) throws IOException {
        int sign = value >> 31;
        int mt = sign & 0x20;
        value = Math.min(23, sign ^ value);
        this.m_os.write(mt | value);
    }

    public void writeTag(long tag) throws IOException {
        if (tag < 0L) {
            throw new IllegalArgumentException("Invalid tag specification, cannot be negative!");
        }
        this.writeType(6, tag);
    }

    public void writeTextString(String value) throws IOException {
        this.writeString(3, value == null ? null : value.getBytes("UTF-8"));
    }

    public void writeTextStringStart() throws IOException {
        this.writeSimpleType(3, 31);
    }

    public void writeUndefined() throws IOException {
        this.writeSimpleType(7, 23);
    }

    protected void writeSimpleType(int majorType, int value) throws IOException {
        this.m_os.write(majorType << 5 | value & 0x1F);
    }

    protected void writeString(int majorType, byte[] bytes) throws IOException {
        int len = bytes == null ? 0 : bytes.length;
        this.writeType(majorType, len);
        for (int i = 0; i < len; ++i) {
            this.m_os.write(bytes[i]);
        }
    }

    protected void writeType(int majorType, long value) throws IOException {
        this.writeUInt(majorType << 5, value);
    }

    protected void writeUInt(int mt, long value) throws IOException {
        if (value < 24L) {
            this.m_os.write((int)((long)mt | value));
        } else if (value < 256L) {
            this.writeUInt8(mt, (int)value);
        } else if (value < 65536L) {
            this.writeUInt16(mt, (int)value);
        } else if (value < 0x100000000L) {
            this.writeUInt32(mt, (int)value);
        } else {
            this.writeUInt64(mt, value);
        }
    }

    protected void writeUInt16(int mt, int value) throws IOException {
        this.m_os.write(mt | 0x19);
        this.m_os.write(value >> 8);
        this.m_os.write(value & 0xFF);
    }

    protected void writeUInt32(int mt, int value) throws IOException {
        this.m_os.write(mt | 0x1A);
        this.m_os.write(value >> 24);
        this.m_os.write(value >> 16);
        this.m_os.write(value >> 8);
        this.m_os.write(value & 0xFF);
    }

    protected void writeUInt64(int mt, long value) throws IOException {
        this.m_os.write(mt | 0x1B);
        this.m_os.write((int)(value >> 56));
        this.m_os.write((int)(value >> 48));
        this.m_os.write((int)(value >> 40));
        this.m_os.write((int)(value >> 32));
        this.m_os.write((int)(value >> 24));
        this.m_os.write((int)(value >> 16));
        this.m_os.write((int)(value >> 8));
        this.m_os.write((int)(value & 0xFFL));
    }

    protected void writeUInt8(int mt, int value) throws IOException {
        this.m_os.write(mt | 0x18);
        this.m_os.write(value & 0xFF);
    }
}

