/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.patchkaraf;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.xipki.patchkaraf.PatchUtil;

public class PatchFeature {
    public static void main(String[] args) {
        try {
            System.exit(PatchFeature.func(args));
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int func(String[] args) throws IOException {
        File origFile;
        boolean patchBootFeatures;
        if (args == null || args.length == 0 || args[0].equals("--help") || args.length % 2 != 0) {
            return PatchFeature.printUsage("");
        }
        String fileName = null;
        String repos = null;
        String featuresStr = null;
        boolean backup = true;
        for (int i = 0; i < args.length; i += 2) {
            String option = args[i];
            String value = args[i + 1];
            if ("--file".equalsIgnoreCase(option)) {
                fileName = value;
                continue;
            }
            if ("--repos".equalsIgnoreCase(option)) {
                repos = value;
                continue;
            }
            if ("--features".equalsIgnoreCase(option)) {
                featuresStr = value.trim();
                continue;
            }
            if (!"--backup".equalsIgnoreCase(option)) continue;
            backup = Boolean.parseBoolean(value);
        }
        if (PatchUtil.isBlank(fileName)) {
            return PatchFeature.printUsage("file is not specified");
        }
        if (PatchUtil.isBlank(repos) && PatchUtil.isBlank(featuresStr)) {
            return PatchFeature.printUsage("nothing to patch");
        }
        LinkedList<String> featuresToRemove = new LinkedList<String>();
        LinkedList<String> featuresToAddPhase0 = new LinkedList<String>();
        LinkedList<String> featuresToAddPhase1 = new LinkedList<String>();
        boolean addPhase = featuresStr.startsWith("(");
        if (addPhase) {
            int phase0EndIndex = featuresStr.indexOf(41);
            String phase0FeaturesStr = featuresStr.substring(1, phase0EndIndex);
            featuresStr = featuresStr.substring(phase0EndIndex + 1);
            StringTokenizer tokenizer = new StringTokenizer(phase0FeaturesStr, ", ");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.startsWith("-")) {
                    featuresToRemove.add(token.substring(1));
                    continue;
                }
                featuresToAddPhase0.add(token);
            }
        }
        StringTokenizer tokenizer = new StringTokenizer(featuresStr, ", ");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.startsWith("-")) {
                featuresToRemove.add(token.substring(1));
                continue;
            }
            featuresToAddPhase1.add(token);
        }
        if (featuresToAddPhase1.isEmpty()) {
            addPhase = false;
        }
        boolean bl = patchBootFeatures = addPhase || !featuresToRemove.isEmpty() || !featuresToAddPhase0.isEmpty() || !featuresToAddPhase1.isEmpty();
        if (PatchUtil.isBlank(repos) && !patchBootFeatures) {
            return PatchFeature.printUsage("nothing to patch");
        }
        File file = new File(fileName);
        File tmpNewFile = new File(fileName + ".new");
        BufferedReader reader = new BufferedReader(new FileReader(file));
        BufferedWriter writer = new BufferedWriter(new FileWriter(tmpNewFile));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                StringBuilder sb;
                String line2;
                if (line.startsWith("featuresRepositories =") && !PatchUtil.isBlank(repos)) {
                    line2 = PatchUtil.readContinuedLine(reader, line);
                    sb = new StringBuilder();
                    sb.append("featuresRepositories = \\\n");
                    StringTokenizer reposTokenizer = new StringTokenizer(repos, ", \n\r");
                    while (reposTokenizer.hasMoreTokens()) {
                        sb.append("    ").append(reposTokenizer.nextToken()).append(", \\\n");
                    }
                    String value2 = line2.substring("featuresRepositories =".length()).trim();
                    reposTokenizer = new StringTokenizer(value2, ", \n\r");
                    while (reposTokenizer.hasMoreTokens()) {
                        sb.append("    ").append(reposTokenizer.nextToken()).append(", \\\n");
                    }
                    int len = sb.length();
                    sb.delete(len - 4, len);
                    writer.write(sb.toString());
                } else if (line.startsWith("featuresBoot =") && patchBootFeatures) {
                    String feature;
                    int i;
                    line2 = PatchUtil.readContinuedLine(reader, line);
                    sb = new StringBuilder();
                    String value2 = line2.substring("featuresBoot =".length()).trim();
                    StringTokenizer featuresTokenizer = new StringTokenizer(value2, ", \n\r");
                    LinkedList<String> origFeaturesInPhase0 = new LinkedList<String>();
                    while (featuresTokenizer.hasMoreTokens()) {
                        String feature2 = featuresTokenizer.nextToken().trim();
                        boolean add = true;
                        for (String featureToRemove : featuresToRemove) {
                            if (!feature2.equals(featureToRemove) && !feature2.startsWith(featureToRemove + "/")) continue;
                            add = false;
                            break;
                        }
                        if (!add) continue;
                        origFeaturesInPhase0.add(feature2);
                    }
                    LinkedList<String> featuresInPhase0 = new LinkedList<String>();
                    featuresInPhase0.addAll(origFeaturesInPhase0);
                    featuresInPhase0.addAll(featuresToAddPhase0);
                    if (addPhase) {
                        sb.append("featuresBoot = ( \\\n");
                    } else {
                        sb.append("featuresBoot = \\\n");
                    }
                    int n = featuresInPhase0.size();
                    for (i = 0; i < n; ++i) {
                        feature = (String)featuresInPhase0.get(i);
                        if (i == n - 1) {
                            sb.append("    ").append(feature);
                            if (addPhase) {
                                sb.append(")");
                            }
                            if (featuresToAddPhase1.isEmpty()) {
                                sb.append("\n");
                                continue;
                            }
                            sb.append(", \\\n");
                            continue;
                        }
                        sb.append("    ").append(feature).append(", \\\n");
                    }
                    n = featuresToAddPhase1.size();
                    for (i = 0; i < n; ++i) {
                        feature = (String)featuresToAddPhase1.get(i);
                        if (i == n - 1) {
                            sb.append("    ").append(feature);
                            continue;
                        }
                        sb.append("    ").append(feature).append(", \\\n");
                    }
                    writer.write(sb.toString());
                } else {
                    writer.write(line);
                }
                writer.write(10);
            }
        }
        finally {
            reader.close();
            writer.close();
        }
        if (backup && !PatchUtil.rename(file, origFile = new File(fileName + ".orig"))) {
            return PatchFeature.printUsage("could not rename " + file.getPath() + " to " + origFile.getPath());
        }
        if (!PatchUtil.rename(tmpNewFile, file)) {
            return PatchFeature.printUsage("could not rename " + tmpNewFile.getPath() + " to " + file.getPath());
        }
        System.out.println("Patched file " + fileName);
        return 0;
    }

    private static int printUsage(String message) {
        StringBuilder sb = new StringBuilder();
        if (!PatchUtil.isBlank(message)) {
            sb.append(message).append("\n");
        }
        sb.append("\nSYNTAX");
        sb.append("\n\tjava " + PatchFeature.class.getName() + " [options]");
        sb.append("\nOPTIONS");
        sb.append("\n\t--file");
        sb.append("\n\t\tFile to be patched");
        sb.append("\n\t--backup");
        sb.append("\n\t\tWhether to create a backup of the patched file (with appendix .orig)");
        sb.append("\n\t\t(defaults to true)");
        sb.append("\n\t--repos");
        sb.append("\n\t\tComma-separated repositories");
        sb.append("\n\t--features");
        sb.append("\n\t\tFeatures in form of [(f1,...,fk),]fk+1,fn where fx is the feature name");
        sb.append("\n\t--help");
        sb.append("\n\t\tDisplay this help message");
        System.out.println(sb.toString());
        return -1;
    }
}

