/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.patchkaraf;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.xipki.patchkaraf.PatchUtil;

public class PatchPaxUrlMvn {
    public static void main(String[] args) {
        try {
            System.exit(PatchPaxUrlMvn.func(args));
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int func(String[] args) throws IOException {
        File origFile;
        if (args == null || args.length == 0 || args[0].equals("--help") || args.length % 2 != 0) {
            return PatchPaxUrlMvn.printUsage("");
        }
        String fileName = null;
        boolean backup = true;
        for (int i = 0; i < args.length; i += 2) {
            String option = args[i];
            String value = args[i + 1];
            if ("--file".equalsIgnoreCase(option)) {
                fileName = value;
                continue;
            }
            if (!"--backup".equalsIgnoreCase(option)) continue;
            backup = Boolean.parseBoolean(value);
        }
        if (PatchUtil.isBlank(fileName)) {
            return PatchPaxUrlMvn.printUsage("file is not specified");
        }
        File file = new File(fileName);
        File tmpNewFile = new File(fileName + ".new");
        BufferedReader reader = new BufferedReader(new FileReader(file));
        BufferedWriter writer = new BufferedWriter(new FileWriter(tmpNewFile));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#org.ops4j.pax.url.mvn.localRepository")) {
                    writer.write("org.ops4j.pax.url.mvn.localRepository=${karaf.home}/not-exists");
                } else if (line.startsWith("org.ops4j.pax.url.mvn.repositories=")) {
                    writer.write(PatchUtil.commentContinuedLine(reader, line));
                    writer.write("\norg.ops4j.pax.url.mvn.repositories=http://127.0.0.1/notexists@id=dummy");
                } else {
                    writer.write(line);
                }
                writer.write(10);
            }
        }
        finally {
            reader.close();
            writer.close();
        }
        if (backup && !PatchUtil.rename(file, origFile = new File(fileName + ".orig"))) {
            return PatchPaxUrlMvn.printUsage("could not rename " + file.getPath() + " to " + origFile.getPath());
        }
        if (!PatchUtil.rename(tmpNewFile, file)) {
            return PatchPaxUrlMvn.printUsage("could not rename " + tmpNewFile.getPath() + " to " + file.getPath());
        }
        System.out.println("Patched file " + fileName);
        return 0;
    }

    private static int printUsage(String message) {
        StringBuilder sb = new StringBuilder();
        if (!PatchUtil.isBlank(message)) {
            sb.append(message).append("\n");
        }
        sb.append("\nSYNTAX");
        sb.append("\n\tjava " + PatchPaxUrlMvn.class.getName() + " [options]");
        sb.append("\nOPTIONS");
        sb.append("\n\t--file");
        sb.append("\n\t\tFile to be patched");
        sb.append("\n\t--backup");
        sb.append("\n\t\tWhether to create a backup of the patched file (with appendix .orig)");
        sb.append("\n\t\t(defaults to true)");
        sb.append("\n\t--help");
        sb.append("\n\t\tDisplay this help message");
        System.out.println(sb.toString());
        return -1;
    }
}

