/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.patchkaraf;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.xipki.patchkaraf.PatchUtil;

public class PatchAppend {
    public static void main(String[] args) {
        try {
            System.exit(PatchAppend.func(args));
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int func(String[] args) throws IOException {
        File origFile;
        if (args == null || args.length == 0 || args[0].equals("--help") || args.length % 2 != 0) {
            return PatchAppend.printUsage("");
        }
        String fileName = null;
        String appendValue = null;
        String appendValueFileName = null;
        boolean backup = true;
        for (int i = 0; i < args.length; i += 2) {
            String option = args[i];
            String value = args[i + 1];
            if ("--file".equalsIgnoreCase(option)) {
                fileName = value;
                continue;
            }
            if ("--value".equalsIgnoreCase(option)) {
                appendValue = value;
                continue;
            }
            if ("--value-file".equalsIgnoreCase(option)) {
                appendValueFileName = value;
                continue;
            }
            if (!"--backup".equalsIgnoreCase(option)) continue;
            backup = Boolean.parseBoolean(value);
        }
        if (PatchUtil.isBlank(fileName)) {
            return PatchAppend.printUsage("file is not specified");
        }
        if (PatchUtil.isBlank(appendValue) && PatchUtil.isBlank(appendValueFileName)) {
            return PatchAppend.printUsage("nothing to patch");
        }
        File file = new File(fileName);
        File tmpNewFile = new File(fileName + ".new");
        BufferedReader reader = new BufferedReader(new FileReader(file));
        BufferedWriter writer = new BufferedWriter(new FileWriter(tmpNewFile));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.write(10);
            }
            if (!PatchUtil.isBlank(appendValue)) {
                writer.write(appendValue);
                writer.write(10);
            } else {
                reader.close();
                reader = new BufferedReader(new FileReader(appendValueFileName));
                while ((line = reader.readLine()) != null) {
                    writer.write(line);
                    writer.write(10);
                }
            }
        }
        finally {
            reader.close();
            writer.close();
        }
        if (backup && !PatchUtil.rename(file, origFile = new File(fileName + ".orig"))) {
            return PatchAppend.printUsage("could not rename " + file.getPath() + " to " + origFile.getPath());
        }
        if (!PatchUtil.rename(tmpNewFile, file)) {
            return PatchAppend.printUsage("could not rename " + tmpNewFile.getPath() + " to " + file.getPath());
        }
        System.out.println("Patched file " + fileName);
        return 0;
    }

    private static int printUsage(String message) {
        StringBuilder sb = new StringBuilder();
        if (!PatchUtil.isBlank(message)) {
            sb.append(message).append("\n");
        }
        sb.append("\nSYNTAX");
        sb.append("\n\tjava " + PatchAppend.class.getName() + " [options]");
        sb.append("\nOPTIONS");
        sb.append("\n\t--file");
        sb.append("\n\t\tFile to be patched");
        sb.append("\n\t--backup");
        sb.append("\n\t\tWhether to create a backup of the patched file (with appendix .orig)");
        sb.append("\n\t\t(defaults to true)");
        sb.append("\n\t--value");
        sb.append("\n\t\tContent to be appended");
        sb.append("\n\t--value-file");
        sb.append("\n\t\tFile that contains the content to be appended");
        sb.append("\n\t--help");
        sb.append("\n\t\tDisplay this help message");
        System.out.println(sb.toString());
        return -1;
    }
}

